@extends('admin.layouts.app')

@section('title', 'Notification Details')

@section('content')
<div class="dashboard-grid">
    <!-- Main Details Card -->
    <div class="card" style="grid-column: 1 / -1;">
        <div class="card-header">
            <h2 class="card-title">Notification Details: {{ $notification->title }}</h2>
            <div style="display: flex; gap: 8px;">
                @if($notification->status === 'draft')
                    <a href="{{ route('admin.notifications.edit', $notification) }}" class="btn btn-primary">Edit</a>
                    <form action="{{ route('admin.notifications.send', $notification) }}" method="POST" style="display: inline;">
                        @csrf
                        <button type="submit" class="btn btn-success" style="background-color: #10b981; color: white; border: none; padding: 8px 16px; border-radius: 6px; cursor: pointer;">Send Now</button>
                    </form>
                @endif
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-secondary">Back to List</a>
            </div>
        </div>

        <div style="padding: 20px;">
            <div style="margin-bottom: 24px;">
                <h3 style="margin: 0 0 8px 0; font-size: 1.1rem; color: var(--text-secondary);">Message</h3>
                <div style="padding: 16px; background: #f8fafc; border: 1px solid var(--border-color); border-radius: 8px; font-size: 1.1rem;">
                    {{ $notification->message }}
                </div>
            </div>

            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 24px; margin-bottom: 24px;">
                <div>
                    <h4 style="margin: 0 0 8px 0; color: var(--text-secondary);">Status</h4>
                    <span class="status-badge" style="font-size: 1rem; padding: 6px 12px;
                        @if($notification->status == 'sent') background: #dcfce7; color: #166534;
                        @elseif($notification->status == 'draft') background: #f3e8ff; color: #7c3aed;
                        @elseif($notification->status == 'scheduled') background: #fef3c7; color: #d97706;
                        @else background: #fee2e2; color: #dc2626; @endif">
                        {{ ucfirst($notification->status) }}
                    </span>
                </div>
                <div>
                    <h4 style="margin: 0 0 8px 0; color: var(--text-secondary);">Target Type</h4>
                    <span style="font-weight: 600;">{{ ucfirst(str_replace('_', ' ', $notification->target_type)) }}</span>
                </div>
                <div>
                    <h4 style="margin: 0 0 8px 0; color: var(--text-secondary);">Created At</h4>
                    <span>{{ $notification->created_at->format('M d, Y H:i') }}</span>
                </div>
                @if($notification->sent_at)
                <div>
                    <h4 style="margin: 0 0 8px 0; color: var(--text-secondary);">Sent At</h4>
                    <span>{{ $notification->sent_at->format('M d, Y H:i') }}</span>
                </div>
                @endif
            </div>

            @if($notification->deep_link_url)
            <div style="margin-bottom: 24px;">
                <h4 style="margin: 0 0 8px 0; color: var(--text-secondary);">Deep Link</h4>
                <code style="padding: 8px 12px; background: #f1f5f9; border-radius: 6px; display: block;">{{ $notification->deep_link_url }}</code>
            </div>
            @endif
        </div>
    </div>

    <!-- Stats Cards (Only if sent) -->
    @if(in_array($notification->status, ['sent', 'partially_sent']))
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Delivery Stats</h3>
        </div>
        <div class="card-value">{{ $stats['delivered'] ?? 0 }} / {{ $stats['total_deliveries'] ?? 0 }}</div>
        <div class="card-change">{{ $stats['delivery_rate'] ?? 0 }}% Delivery Rate</div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Open Rate</h3>
        </div>
        <div class="card-value">{{ $stats['opened'] ?? 0 }}</div>
        <div class="card-change">{{ $stats['open_rate'] ?? 0 }}% of Delivered</div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Click Rate</h3>
        </div>
        <div class="card-value">{{ $stats['clicked'] ?? 0 }}</div>
        <div class="card-change">{{ $stats['click_rate'] ?? 0 }}% of Delivered</div>
    </div>
    @endif
</div>
@endsection
