@extends('admin.layouts.app')

@section('title', 'Scheduled Notifications')

@section('content')
<div class="dashboard-grid">
    <div class="card" style="grid-column: 1 / -1;">
        <div class="card-header">
            <h2 class="card-title">Scheduled Notifications</h2>
            <div style="display: flex; gap: 8px;">
                <a href="{{ route('admin.notifications.create') }}" class="btn btn-primary">Create Notification</a>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-secondary">All Notifications</a>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Type</th>
                        <th>Target</th>
                        <th>Scheduled For</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($notifications as $notification)
                        <tr>
                            <td>
                                <div>
                                    <strong>{{ $notification->title }}</strong>
                                    <br><small style="color: var(--text-secondary);">{{ Str::limit($notification->message, 50) }}</small>
                                </div>
                            </td>
                            <td>
                                <span class="status-badge" style="background: #e0e7ff; color: #3730a3;">{{ $notification->targetTypeLabel }}</span>
                            </td>
                            <td>
                                @if($notification->target_type === 'premium_plan')
                                    <span class="status-badge" style="background: #f3e8ff; color: #7c3aed;">Plan Users</span>
                                @elseif($notification->target_type === 'single_user')
                                    <span class="status-badge" style="background: #dcfce7; color: #166534;">Single User</span>
                                @else
                                    <span class="status-badge" style="background: #e0f2fe; color: #0369a1;">{{ ucfirst($notification->target_type) }}</span>
                                @endif
                            </td>
                            <td>{{ $notification->scheduled_at ? $notification->scheduled_at->format('M d, Y H:i') : 'N/A' }}</td>
                            <td>
                                <div style="display: flex; gap: 8px;">
                                    <a href="{{ route('admin.notifications.show', $notification) }}" class="btn btn-sm" style="background: #3b82f6; color: white; padding: 4px 8px; border-radius: 4px; text-decoration: none; font-size: 12px;">View</a>
                                    <a href="{{ route('admin.notifications.analytics', $notification) }}" class="btn btn-sm" style="background: #f59e0b; color: white; padding: 4px 8px; border-radius: 4px; text-decoration: none; font-size: 12px;">Analytics</a>
                                    <form action="{{ route('admin.notifications.destroy', $notification) }}" method="POST" style="display: inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm" style="background: #ef4444; color: white; padding: 4px 8px; border-radius: 4px; border: none; font-size: 12px;" onclick="return confirm('Are you sure?')">Cancel</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" style="text-align: center; color: var(--text-secondary); padding: 40px;">No scheduled notifications found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div style="margin-top: 20px;">
            {{ $notifications->links() }}
        </div>
    </div>
</div>
@endsection
