@extends('admin.layouts.app')

@section('title', 'Notification Dashboard')

@section('content')
    <div class="dashboard-header">
        <h1 style="margin: 0; font-size: 1.5rem; color: var(--text-primary);">Notification Dashboard</h1>
        <div style="font-size: 0.875rem; color: var(--text-secondary);">Monitor and manage your notification campaigns</div>
    </div>

    <!-- Key Metrics -->
    <div class="metrics-grid">
        <div class="metric-card">
            <div class="metric-icon">
                <i class="fas fa-bell"></i>
            </div>
            <div class="metric-content">
                <div class="metric-value" id="totalNotifications">0</div>
                <div class="metric-label">Total Notifications</div>
            </div>
        </div>

        <div class="metric-card">
            <div class="metric-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="metric-content">
                <div class="metric-value" id="deliveredNotifications">0</div>
                <div class="metric-label">Delivered</div>
            </div>
        </div>

        <div class="metric-card">
            <div class="metric-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="metric-content">
                <div class="metric-value" id="scheduledNotifications">0</div>
                <div class="metric-label">Scheduled</div>
            </div>
        </div>

        <div class="metric-card">
            <div class="metric-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="metric-content">
                <div class="metric-value" id="failedNotifications">0</div>
                <div class="metric-label">Failed</div>
            </div>
        </div>
    </div>

    <!-- Charts and Analytics -->
    <div class="analytics-section">
        <div class="chart-container">
            <h3 style="margin-bottom: 16px; color: var(--text-primary);">Delivery Performance</h3>
            <canvas id="deliveryChart" width="400" height="200"></canvas>
        </div>

        <div class="chart-container">
            <h3 style="margin-bottom: 16px; color: var(--text-primary);">Notification Types</h3>
            <canvas id="typeChart" width="400" height="200"></canvas>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="activity-section">
        <div class="section-header">
            <h3 style="margin: 0; color: var(--text-primary);">Recent Activity</h3>
            <div class="section-actions">
                <button onclick="refreshDashboard()" class="btn-secondary">Refresh</button>
                <button onclick="exportReport()" class="btn-info">Export Report</button>
            </div>
        </div>

        <div class="activity-feed">
            <div id="activityList">
                <!-- Activity items will be loaded here -->
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions">
        <h3 style="margin-bottom: 16px; color: var(--text-primary);">Quick Actions</h3>
        <div class="action-grid">
            <a href="{{ route('notifications.create') }}" class="action-card">
                <div class="action-icon">
                    <i class="fas fa-plus-circle"></i>
                </div>
                <div class="action-content">
                    <h4>Create Notification</h4>
                    <p>Send a new notification to your users</p>
                </div>
            </a>

            <a href="{{ route('notifications.advanced.create') }}" class="action-card">
                <div class="action-icon">
                    <i class="fas fa-rocket"></i>
                </div>
                <div class="action-content">
                    <h4>Advanced Campaign</h4>
                    <p>Create A/B tested campaigns with targeting</p>
                </div>
            </a>

            <a href="{{ route('notifications.schedule') }}" class="action-card">
                <div class="action-icon">
                    <i class="fas fa-calendar-alt"></i>
                </div>
                <div class="action-content">
                    <h4>Schedule Notifications</h4>
                    <p>Schedule notifications for optimal timing</p>
                </div>
            </a>

            <a href="{{ route('notifications.settings') }}" class="action-card">
                <div class="action-icon">
                    <i class="fas fa-cog"></i>
                </div>
                <div class="action-content">
                    <h4>Settings</h4>
                    <p>Configure notification preferences and channels</p>
                </div>
            </a>
        </div>
    </div>

    <style>
        .dashboard-header {
            margin-bottom: 24px;
            padding-bottom: 16px;
            border-bottom: 1px solid var(--border-color);
        }

        .metrics-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 16px;
            margin-bottom: 32px;
        }

        .metric-card {
            background: white;
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            display: flex;
            align-items: center;
            gap: 16px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .metric-icon {
            width: 48px;
            height: 48px;
            background: var(--primary-color);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.25rem;
        }

        .metric-content {
            flex: 1;
        }

        .metric-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-primary);
        }

        .metric-label {
            font-size: 0.875rem;
            color: var(--text-secondary);
        }

        .analytics-section {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 24px;
            margin-bottom: 32px;
        }

        .chart-container {
            background: white;
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
        }

        .activity-section {
            background: white;
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 32px;
        }

        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 16px;
            padding-bottom: 16px;
            border-bottom: 1px solid var(--border-color);
        }

        .section-actions {
            display: flex;
            gap: 8px;
        }

        .activity-feed {
            max-height: 400px;
            overflow-y: auto;
        }

        .quick-actions {
            margin-bottom: 32px;
        }

        .action-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 16px;
        }

        .action-card {
            display: flex;
            align-items: center;
            gap: 16px;
            padding: 20px;
            border: 1px solid var(--border-color);
            border-radius: 12px;
            text-decoration: none;
            color: inherit;
            transition: all 0.2s ease;
            background: white;
        }

        .action-card:hover {
            border-color: var(--primary-color);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .action-icon {
            width: 48px;
            height: 48px;
            background: var(--primary-color);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.25rem;
        }

        .action-content h4 {
            margin: 0 0 4px 0;
            font-size: 1rem;
            color: var(--text-primary);
        }

        .action-content p {
            margin: 0;
            font-size: 0.875rem;
            color: var(--text-secondary);
        }

        .btn-secondary, .btn-info {
            padding: 8px 16px;
            border-radius: 8px;
            border: none;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .btn-secondary {
            background: #e2e8f0;
            color: #334155;
        }

        .btn-secondary:hover {
            background: #cbd5e1;
        }

        .btn-info {
            background: #38bdf8;
            color: white;
        }

        .btn-info:hover {
            background: #0ea5e9;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .metrics-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .analytics-section {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            loadDashboardData();
            initializeCharts();
        });

        function loadDashboardData() {
            // Load metrics
            fetch('{{ route('notifications.metrics') }}')
                .then(response => response.json())
                .then(data => {
                    document.getElementById('totalNotifications').textContent = data.total;
                    document.getElementById('deliveredNotifications').textContent = data.delivered;
                    document.getElementById('scheduledNotifications').textContent = data.scheduled;
                    document.getElementById('failedNotifications').textContent = data.failed;
                });

            // Load recent activity
            fetch('{{ route('notifications.recent') }}')
                .then(response => response.json())
                .then(data => {
                    const activityList = document.getElementById('activityList');
                    activityList.innerHTML = data.map(item => `
                        <div class="activity-item">
                            <div class="activity-time">${item.time}</div>
                            <div class="activity-content">
                                <strong>${item.title}</strong>
                                <p>${item.message}</p>
                            </div>
                        </div>
                    `).join('');
                });
        }

        function initializeCharts() {
            // Delivery Performance Chart
            const deliveryCtx = document.getElementById('deliveryChart').getContext('2d');
            new Chart(deliveryCtx, {
                type: 'line',
                data: {
                    labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                    datasets: [{
                        label: 'Delivered',
                        data: [12, 19, 3, 5, 2, 3, 7],
                        borderColor: '#22c55e',
                        backgroundColor: 'rgba(34, 197, 94, 0.1)',
                        tension: 0.4
                    }, {
                        label: 'Failed',
                        data: [2, 3, 1, 2, 1, 0, 1],
                        borderColor: '#ef4444',
                        backgroundColor: 'rgba(239, 68, 68, 0.1)',
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'top',
                        }
                    }
                }
            });

            // Notification Types Chart
            const typeCtx = document.getElementById('typeChart').getContext('2d');
            new Chart(typeCtx, {
                type: 'doughnut',
                data: {
                    labels: ['General', 'Promotions', 'Security', 'Updates', 'Reminders'],
                    datasets: [{
                        data: [30, 25, 20, 15, 10],
                        backgroundColor: [
                            '#3b82f6',
                            '#10b981',
                            '#f59e0b',
                            '#ef4444',
                            '#8b5cf6'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom',
                        }
                    }
                }
            });
        }

        function refreshDashboard() {
            loadDashboardData();
            // Reload charts would require destroying and recreating them
            // For simplicity, we'll just reload the page
            location.reload();
        }

        function exportReport() {
            // This would trigger a PDF/CSV export
            alert('Export functionality would be implemented here');
        }
    </script>
@endsection
