@extends('admin.layouts.app')

@section('title', 'Notification Analytics')

@section('content')
<div class="dashboard-grid">
    <div class="card" style="grid-column: 1 / -1;">
        <div class="card-header">
            <h2 class="card-title">Analytics: {{ $notification->title }}</h2>
            <div style="display: flex; gap: 8px;">
                <a href="{{ route('admin.notifications.show', $notification) }}" class="btn btn-secondary">details</a>
                <a href="{{ route('admin.notifications.index') }}" class="btn btn-secondary">Back to List</a>
            </div>
        </div>
        
        <div class="metrics-grid" style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 16px; padding: 20px;">
            <div style="background: #f8fafc; padding: 16px; border-radius: 8px; text-align: center;">
                <h3 style="margin: 0; font-size: 2rem; color: #3b82f6;">{{ $stats['total_deliveries'] }}</h3>
                <span style="color: var(--text-secondary);">Total Targeted</span>
            </div>
            <div style="background: #f0fdf4; padding: 16px; border-radius: 8px; text-align: center;">
                <h3 style="margin: 0; font-size: 2rem; color: #166534;">{{ $stats['delivered'] }}</h3>
                <span style="color: var(--text-secondary);">Delivered</span>
            </div>
            <div style="background: #fffbeb; padding: 16px; border-radius: 8px; text-align: center;">
                <h3 style="margin: 0; font-size: 2rem; color: #d97706;">{{ $stats['opened'] }}</h3>
                <span style="color: var(--text-secondary);">Opened ({{ $stats['open_rate'] }}%)</span>
            </div>
            <div style="background: #eef2ff; padding: 16px; border-radius: 8px; text-align: center;">
                <h3 style="margin: 0; font-size: 2rem; color: #4f46e5;">{{ $stats['clicked'] }}</h3>
                <span style="color: var(--text-secondary);">Clicked ({{ $stats['click_rate'] }}%)</span>
            </div>
        </div>

        <div style="padding: 20px;">
            <h3 style="margin-bottom: 16px;">Delivery Breakdown</h3>
            @if(count($deliveryBreakdown) > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Status</th>
                            <th>Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($deliveryBreakdown as $status)
                            <tr>
                                <td>{{ ucfirst($status->status) }}</td>
                                <td>{{ $status->count }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p style="color: var(--text-secondary);">No delivery data available yet.</p>
            @endif
        </div>

        <div style="padding: 20px;">
            <h3 style="margin-bottom: 16px;">Engagement by Plan</h3>
            @if(count($engagementByPlan) > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Plan Type</th>
                            <th>Targeted</th>
                            <th>Clicks</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($engagementByPlan as $plan)
                            <tr>
                                <td>{{ ucfirst($plan->plan_type) }}</td>
                                <td>{{ $plan->count }}</td>
                                <td>{{ $plan->clicks }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p style="color: var(--text-secondary);">No engagement data available yet.</p>
            @endif
        </div>
    </div>
</div>
@endsection
