<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" id="html-theme">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'CLX Admin') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Leaflet Maps -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>

    <!-- Styles -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
      tailwind.config = {
        theme: {
          extend: {
            colors: {
              primary: '#7c3aed',
            }
          }
        }
      }
    </script>
    <style>
        :root {
            --primary-color: #7c3aed;
            --primary-hover: #6d28d9;
            --bg-color: #f8fafc;
            --card-bg: #ffffff;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --border-color: #e2e8f0;
            --success-color: #10b981;
            --warning-color: #f59e0b;
            --danger-color: #ef4444;
            --shadow-color: rgba(0, 0, 0, 0.1);
        }

        /* Dark Theme Variables */
        [data-theme="dark"] {
            --primary-color: #a78bfa;
            --primary-hover: #8b5cf6;
            --bg-color: #0f172a;
            --card-bg: #111827;
            --text-primary: #f3f4f6;
            --text-secondary: #9ca3af;
            --border-color: #1f2937;
            --success-color: #34d399;
            --warning-color: #fbbf24;
            --danger-color: #f87171;
            --shadow-color: rgba(0, 0, 0, 0.3);
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Figtree', system-ui, -apple-system, Segoe UI, Roboto, sans-serif;
            background-color: var(--bg-color);
            color: var(--text-primary);
            margin: 0;
            padding: 0;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .admin-layout {
            display: grid;
            grid-template-columns: 280px 1fr;
            grid-template-rows: auto 1fr; /* Row 1:header height, Row 2:remaining space */
            min-height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            grid-column: 1;
            grid-row: 1 / span 2; /* Span both header and content rows */
            background: var(--card-bg);
            border-right: 1px solid var(--border-color);
            overflow-y: auto;
            max-height: 100vh;
            position: sticky;
            top: 0;
            z-index: 50;
        }

        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            gap: 12px;
            transition: border-color 0.3s ease;
        }

        .logo {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--primary-color);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-icon {
            width: 32px;
            height: 32px;
            background: linear-gradient(135deg, var(--primary-color), #22d3ee);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }

        .nav-menu {
            padding: 20px;
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        .nav-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            border-radius: 8px;
            text-decoration: none;
            color: var(--text-secondary);
            transition: all 0.2s ease;
            font-weight: 500;
        }

        .nav-item:hover {
            background-color: var(--border-color);
            color: var(--text-primary);
        }

        .nav-item.active {
            background-color: #f3e8ff;
            color: var(--primary-color);
            border-left: 4px solid var(--primary-color);
        }

        [data-theme="dark"] .nav-item.active {
            background-color: #1f2937;
            color: var(--primary-color);
            border-left: 4px solid var(--primary-color);
        }

        .nav-icon {
            width: 20px;
            height: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
        }

        .nav-section {
            margin-top: 16px;
            margin-bottom: 8px;
        }

        .nav-section-title {
            padding: 8px 16px;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            color: var(--text-secondary);
            margin-bottom: 8px;
        }

        .sub-nav {
            display: flex;
            flex-direction: column;
            gap: 4px;
            padding-left: 16px;
        }

        .sub-nav a:hover {
            background: var(--border-color);
        }

        [data-theme="dark"] .sub-nav a:hover {
            background: #1f2937;
        }

        /* Header */
        .header {
            grid-column: 2;
            grid-row: 1; /* Explicitly in first row */
            background: var(--card-bg);
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 24px;
            height: 64px;
            position: sticky;
            top: 0;
            z-index: 40;
        }

        .header-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--text-primary);
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        /* Theme Switcher */
        .theme-switcher {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 12px;
            border-radius: 8px;
            border: 1px solid var(--border-color);
            background: var(--card-bg);
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .theme-switcher:hover {
            background: var(--border-color);
        }

        .theme-icon {
            font-size: 18px;
            transition: transform 0.3s ease;
        }

        .theme-switcher.active .theme-icon {
            transform: rotate(180deg);
        }

        .theme-label {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--text-secondary);
        }

        /* Theme Toggle Switch */
        .theme-toggle {
            position: relative;
            width: 50px;
            height: 26px;
            background: var(--border-color);
            border-radius: 999px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .theme-toggle::after {
            content: '';
            position: absolute;
            top: 2px;
            left: 2px;
            width: 22px;
            height: 22px;
            background: white;
            border-radius: 50%;
            transition: transform 0.3s ease;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        [data-theme="dark"] .theme-toggle {
            background: #374151;
        }

        [data-theme="dark"] .theme-toggle::after {
            background: #f3f4f6;
            transform: translateX(24px);
        }

        /* User Menu */
        .user-menu {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 12px;
            border-radius: 8px;
            border: 1px solid var(--border-color);
            background: var(--card-bg);
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .user-menu:hover {
            background: var(--border-color);
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 14px;
        }

        /* Main Content */
        .main-content {
            grid-column: 2;
            grid-row: 2; /* Explicitly in second row */
            padding: 24px;
            background: var(--bg-color);
            min-height: calc(100vh - 64px);
        }

        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-bottom: 24px;
        }

        .card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px var(--shadow-color);
            transition: all 0.2s ease;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 6px var(--shadow-color);
        }

        .card-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 16px;
        }

        .card-title {
            font-size: 0.875rem;
            font-weight: 600;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .card-value {
            font-size: 2rem;
            font-weight: 700;
            color: var(--text-primary);
        }

        .card-change {
            font-size: 0.875rem;
            color: var(--success-color);
            font-weight: 600;
        }

        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            background: #f3e8ff;
            color: var(--primary-color);
        }

        [data-theme="dark"] .stat-icon {
            background: #1f2937;
            color: var(--primary-color);
        }

        /* Charts and Tables */
        .content-grid {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 24px;
            margin-bottom: 24px;
        }

        .chart-card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            transition: background-color 0.3s ease, border-color 0.3s ease;
        }

        .table-card {
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            transition: background-color 0.3s ease, border-color 0.3s ease;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .table th,
        .table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid var(--border-color);
            font-size: 0.875rem;
            transition: border-color 0.3s ease;
        }

        .table th {
            font-weight: 600;
            color: var(--text-secondary);
            background: var(--bg-color);
        }

        .table tr:hover {
            background-color: var(--bg-color);
        }

        .status-badge {
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .status-active {
            background: #dcfce7;
            color: var(--success-color);
        }

        .status-pending {
            background: #fef3c7;
            color: var(--warning-color);
        }

        .status-inactive {
            background: #fee2e2;
            color: var(--danger-color);
        }

        [data-theme="dark"] .status-active {
            background: #064e3b;
            color: var(--success-color);
        }

        [data-theme="dark"] .status-pending {
            background: #78350f;
            color: var(--warning-color);
        }

        [data-theme="dark"] .status-inactive {
            background: #7f1d1d;
            color: var(--danger-color);
        }

        /* Responsive */
        @media (max-width: 1024px) {
            .dashboard-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            .content-grid {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .sidebar.open {
                transform: translateX(0);
            }
            .admin-layout {
                grid-template-columns: 1fr;
            }
            .header {
                grid-column: 1;
            }
            .main-content {
                grid-column: 1;
            }
            .dashboard-grid {
                grid-template-columns: 1fr;
            }
            .content-grid {
                grid-template-columns: 1fr;
            }
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>

    <!-- Leaflet.js CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"
          integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY="
          crossorigin=""/>
    
    <!-- Leaflet MarkerCluster CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.5.3/dist/MarkerCluster.css" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.5.3/dist/MarkerCluster.Default.css" />

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Leaflet.js -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"
            integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo="
            crossorigin=""></script>
    
    <!-- Leaflet MarkerCluster JS -->
    <script src="https://unpkg.com/leaflet.markercluster@1.5.3/dist/leaflet.markercluster.js"></script>

    <!-- Scripts -->
    <script>
        // Theme Management
        function setTheme(theme) {
            const html = document.getElementById('html-theme');
            html.setAttribute('data-theme', theme);
            localStorage.setItem('admin-theme', theme);
            
            // Update theme toggle state
            const toggle = document.querySelector('.theme-toggle');
            const icon = document.querySelector('.theme-icon');
            
            if (theme === 'dark') {
                toggle.classList.add('active');
                icon.textContent = '🌙';
            } else {
                toggle.classList.remove('active');
                icon.textContent = '☀️';
            }
        }

        // Initialize theme
        function initTheme() {
            const savedTheme = localStorage.getItem('admin-theme') || 'light';
            setTheme(savedTheme);
        }

        // Toggle theme
        function toggleTheme() {
            const currentTheme = document.getElementById('html-theme').getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            setTheme(newTheme);
        }

        // Simple responsive sidebar toggle
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('open');
        }

        // Initialize on load
        document.addEventListener('DOMContentLoaded', initTheme);

        // User dropdown toggle
        function toggleUserDropdown() {
            const dropdown = document.getElementById('user-dropdown');
            if (dropdown.style.display === 'block') {
                dropdown.style.display = 'none';
            } else {
                dropdown.style.display = 'block';
            }
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const dropdown = document.getElementById('user-dropdown');
            const userMenu = document.querySelector('.user-menu');
            
            if (!userMenu.contains(event.target) && !dropdown.contains(event.target)) {
                dropdown.style.display = 'none';
            }
        });
    </script>
</head>
<body class="font-sans antialiased">
    <div class="admin-layout">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <a href="{{ route('admin.dashboard') }}" class="logo">
                    <div class="logo-icon">CLX</div>
                    <span>Admin Panel</span>
                </a>
            </div>
            
            <nav class="nav-menu">
                <a href="{{ route('admin.dashboard') }}" class="nav-item {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                    <span class="nav-icon">📊</span>
                    <span>Dashboard</span>
                </a>
                <a href="{{ route('admin.users.index') }}" class="nav-item {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                    <span class="nav-icon">👥</span>
                    <span>Users</span>
                </a>
                <a href="{{ route('admin.ads.index') }}" class="nav-item {{ request()->routeIs('admin.ads.*') ? 'active' : '' }}">
                    <span class="nav-icon">📋</span>
                    <span>Ads</span>
                </a>
                <a href="{{ route('admin.categories.index') }}" class="nav-item {{ request()->routeIs('admin.categories.*') ? 'active' : '' }}">
                    <span class="nav-icon">📁</span>
                    <span>Categories</span>
                </a>
                <a href="{{ route('admin.global_fields.index') }}" class="nav-item {{ request()->routeIs('admin.global_fields.*') ? 'active' : '' }}">
                    <span class="nav-icon">📝</span>
                    <span>Custom Fields</span>
                </a>
                <a href="{{ route('admin.plans.index') }}" class="nav-item {{ request()->routeIs('admin.plans.*') ? 'active' : '' }}">
                    <span class="nav-icon">💎</span>
                    <span>User Plans</span>
                </a>
                <a href="{{ route('admin.packages.index') }}" class="nav-item {{ request()->routeIs('admin.packages.*') ? 'active' : '' }}">
                    <span class="nav-icon">📦</span>
                    <span>Packages</span>
                </a>
                <a href="{{ route('admin.safety.index') }}" class="nav-item {{ request()->routeIs('admin.safety.*') ? 'active' : '' }}">
                    <span class="nav-icon">🛡️</span>
                    <span>Safety & Security</span>
                </a>
                <a href="{{ route('admin.settings.index') }}" class="nav-item {{ request()->routeIs('admin.settings.*') ? 'active' : '' }}">
                    <span class="nav-icon">⚙️</span>
                    <span>Settings</span>
                </a>
                {{-- AI Guardian --}}
                <a href="{{ route('admin.settings.index') }}#guardian-settings" style="text-decoration: none; display: block;">
                    <div style="margin-left: 32px; padding: 8px 12px; border-left: 2px solid var(--primary-soft); margin-bottom: 8px; cursor: pointer; transition: background 0.2s;" onmouseover="this.style.background='rgba(var(--primary-rgb), 0.05)'" onmouseout="this.style.background='transparent'">
                        <div style="font-size: 0.75rem; text-transform: uppercase; color: var(--text-secondary); font-weight: 700; margin-bottom: 8px;">Artificial Intelligence</div>
                        <div style="display: flex; align-items: center; gap: 8px; color: var(--text-primary); font-size: 0.9rem; font-weight: 500;">
                            <span style="width: 8px; height: 8px; background: #10b981; border-radius: 50%; box-shadow: 0 0 8px #10b981;"></span>
                            Guardian Active
                        </div>
                    </div>
                </a>

                <a href="{{ route('admin.analytics') }}" class="nav-item {{ request()->routeIs('admin.analytics') ? 'active' : '' }}">
                    <span class="nav-icon">📊</span>
                    <span>Analytics</span>
                </a>
                <a href="{{ route('admin.algorithm.control') }}" class="nav-item {{ request()->routeIs('admin.algorithm.*') ? 'active' : '' }}">
                    <span class="nav-icon">🤖</span>
                    <span>Algorithm Control</span>
                </a>
                <a href="{{ route('admin.notifications.index') }}" class="nav-item {{ request()->routeIs('admin.notifications.*') ? 'active' : '' }}">
                    <span class="nav-icon">🔔</span>
                    <span>Notifications</span>
                </a>
                <a href="{{ route('admin.monetization.index') }}" class="nav-item {{ request()->routeIs('admin.monetization.*') ? 'active' : '' }}">
                    <span class="nav-icon">💰</span>
                    <span>Monetization</span>
                </a>

                {{-- Banner Promotion with submenu --}}
                <div style="margin-bottom: 8px;">
                    <a href="{{ route('admin.banners.index') }}" class="nav-item {{ request()->routeIs('admin.banners.*') ? 'active' : '' }}">
                        <span class="nav-icon">📢</span>
                        <span>Banner Promotion</span>
                    </a>
                    <div style="padding-left: 32px; display: flex; flex-direction: column; gap: 4px; margin-top: 4px;">
                        <a href="{{ route('admin.banners.index') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.banners.index') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            📋 All Banners
                        </a>
                        <a href="{{ route('admin.banners.create') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.banners.create') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            ➕ Create Banner
                        </a>
                        <a href="{{ route('admin.banners.packages.index') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.banners.packages.*') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            📦 Packages
                        </a>
                        <a href="{{ route('admin.banners.analytics') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.banners.analytics') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            📈 Analytics
                        </a>
                    </div>
                </div>
                
                {{-- Blogs with submenu --}}
                <div style="margin-bottom: 8px;">
                    <a href="{{ route('admin.blogs.index') }}" class="nav-item {{ request()->routeIs('admin.blogs.*') || request()->routeIs('admin.blog-categories.*') ? 'active' : '' }}">
                        <span class="nav-icon">📝</span>
                        <span>Blogs</span>
                    </a>
                    <div style="padding-left: 32px; display: flex; flex-direction: column; gap: 4px; margin-top: 4px;">
                        <a href="{{ route('admin.blogs.index') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.blogs.*') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            📋 All Blogs
                        </a>
                        <a href="{{ route('admin.blog-categories.index') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.blog-categories.*') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            🏷️ Categories
                        </a>
                    </div>
                </div>
                
                {{-- Support with submenu --}}
                <div style="margin-bottom: 8px;">
                    <a href="{{ route('admin.support.tickets') }}" class="nav-item {{ request()->routeIs('admin.support.*') ? 'active' : '' }}">
                        <span class="nav-icon">🎫</span>
                        <span>Help & Support</span>
                    </a>
                    <div style="padding-left: 32px; display: flex; flex-direction: column; gap: 4px; margin-top: 4px;">
                        <a href="{{ route('admin.support.tickets') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.support.tickets*') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            🎫 Tickets
                        </a>
                        <a href="{{ route('admin.support.chats') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.support.chats*') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            💬 Chats
                        </a>
                        <a href="{{ route('admin.support.settings') }}" style="padding: 8px 12px; border-radius: 6px; text-decoration: none; color: var(--text-secondary); font-size: 14px; transition: all 0.2s ease; display: block; {{ request()->routeIs('admin.support.settings') ? 'background: #f3e8ff; color: var(--primary-color); font-weight: 600;' : '' }}">
                            ⚙️ Settings
                        </a>
                    </div>
                </div>
                
                <a href="{{ route('admin.pages.index') }}" class="nav-item {{ request()->routeIs('admin.pages.*') ? 'active' : '' }}">
                    <span class="nav-icon">📄</span>
                    <span>Pages</span>
                </a>
                <a href="{{ route('docs.index') }}" class="nav-item {{ request()->routeIs('docs.*') ? 'active' : '' }}">
                    <span class="nav-icon">📚</span>
                    <span>Documentation</span>
                </a>
            </nav>
        </aside>

        <!-- Header -->
        <header class="header">
            <h1 class="header-title">
                @yield('title', 'Admin Dashboard')
            </h1>
            
            <div class="header-actions">
                <!-- Theme Switcher -->
                <div class="theme-switcher" onclick="toggleTheme()">
                    <span class="theme-icon">☀️</span>
                    <span class="theme-label">Theme</span>
                    <div class="theme-toggle"></div>
                </div>

                @if(auth()->check())
                    <div class="user-menu" onclick="toggleUserDropdown()">
                        <div class="user-avatar">
                            {{ substr(auth()->user()->name, 0, 2) }}
                        </div>
                        <div>
                            <div style="font-weight: 600; font-size: 0.875rem;">{{ auth()->user()->name }}</div>
                            <div style="font-size: 0.75rem; color: var(--text-secondary);">Administrator</div>
                        </div>
                        <div style="margin-left: 8px; font-size: 16px;">▼</div>
                    </div>
                    
                    <!-- User Dropdown -->
                    <div id="user-dropdown" style="position: absolute; top: 100%; right: 0; background: var(--card-bg); border: 1px solid var(--border-color); border-radius: 8px; box-shadow: 0 4px 6px var(--shadow-color); display: none; z-index: 100; min-width: 200px; transition: opacity 0.2s ease;">
                        <a href="{{ route('admin.profile.show') }}" style="display: flex; align-items: center; gap: 12px; padding: 12px 16px; color: var(--text-primary); text-decoration: none; border-bottom: 1px solid var(--border-color); transition: background 0.2s ease;">
                            <span>👤</span>
                            <span>My Profile</span>
                        </a>
                        <a href="{{ route('admin.profile.edit') }}" style="display: flex; align-items: center; gap: 12px; padding: 12px 16px; color: var(--text-primary); text-decoration: none; border-bottom: 1px solid var(--border-color); transition: background 0.2s ease;">
                            <span>✏️</span>
                            <span>Edit Profile</span>
                        </a>
                        <form action="{{ route('admin.logout') }}" method="POST" style="margin: 0;">
                            @csrf
                            <button type="submit" style="width: 100%; display: flex; align-items: center; gap: 12px; padding: 12px 16px; background: none; border: none; color: var(--text-primary); text-decoration: none; cursor: pointer; transition: background 0.2s ease; text-align: left;">
                                <span>🚪</span>
                                <span>Logout</span>
                            </button>
                        </form>
                    </div>
                @endif
            </div>
        </header>

        <!-- Main Content -->
        <main class="main-content">
            @yield('content')
        </main>
    </div>
</body>
</html>
