@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row align-items-center mb-4">
        <div class="col">
            <h1 class="h3 mb-0 text-gray-800">🛡️ Guardian Activity Log</h1>
            <p class="text-muted">Review and manage automated actions taken by the AI.</p>
        </div>
        <div class="col-auto">
            <a href="{{ route('admin.settings.index') }}#guardian-settings" class="btn btn-outline-secondary">
                <i class="fas fa-cog"></i> Settings
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                    <thead class="thead-light">
                        <tr>
                            <th>Time</th>
                            <th>Action</th>
                            <th>Target</th>
                            <th>Reason</th>
                            <th>Status</th>
                            <th>Controls</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($logs as $log)
                            <tr>
                                <td style="white-space: nowrap;">{{ $log->created_at->diffForHumans() }}</td>
                                <td>
                                    @php
                                        $badges = [
                                            'AUTO_BAN' => 'badge-danger',
                                            'SUSPEND' => 'badge-warning',
                                            'FLAG_FOR_REVIEW' => 'badge-warning',
                                            'SUGGEST_CHANGES' => 'badge-info',
                                            'APPROVE' => 'badge-success',
                                        ];
                                        $badgeClass = $badges[$log->action] ?? 'badge-secondary';
                                    @endphp
                                    <span class="badge {{ $badgeClass }}">{{ str_replace('_', ' ', $log->action) }}</span>
                                </td>
                                <td>
                                    <strong>{{ $log->target_type }} #{{ $log->target_id }}</strong>
                                    @if(isset($log->snapshot['title']))
                                        <div class="small text-muted">{{ Str::limit($log->snapshot['title'], 30) }}</div>
                                    @endif
                                    @if(isset($log->snapshot['email']))
                                        <div class="small text-muted">{{ $log->snapshot['email'] }}</div>
                                    @endif
                                </td>
                                <td style="max-width: 300px;">
                                    {{ $log->reason }}
                                    @if(isset($log->snapshot['reports']))
                                        <br><small class="text-danger">{{ $log->snapshot['reports'] }} Reports</small>
                                    @endif
                                </td>
                                <td>
                                    @if($log->is_overwritten)
                                        <span class="text-success"><i class="fas fa-check-circle"></i> Overwritten</span>
                                    @else
                                        <span class="text-secondary">Active</span>
                                    @endif
                                </td>
                                <td>
                                    @if(!$log->is_overwritten && in_array($log->action, ['AUTO_BAN', 'SUSPEND', 'FLAG_FOR_REVIEW']))
                                        <form action="{{ route('admin.guardian.overwrite', $log->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to reverse this action?');">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-primary">
                                                <i class="fas fa-undo"></i> Undo
                                            </button>
                                        </form>
                                    @elseif($log->action == 'SUGGEST_CHANGES')
                                        <span class="text-muted small">User Notified</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-4">No activity recorded yet.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-4">
                {{ $logs->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
