<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Push Notifications Guide - CLX Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .doc-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .step {
            border-left: 4px solid #667eea;
            padding-left: 20px;
            margin-bottom: 2rem;
        }
        .step-number {
            background: #667eea;
            color: white;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 1rem;
        }
        .code-block {
            background: #1f2937;
            color: #f9fafb;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
        }
        .checklist {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin: 1rem 0;
        }
        .btn-doc {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="text-center mb-5">
                    <h1 class="text-white">🔔 Push Notifications Guide</h1>
                    <p class="text-white-50">Master the art of user engagement with targeted push campaigns</p>
                </div>

                <div class="card doc-card border-0">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-md-8">
                                <h3>📋 Overview</h3>
                                <p>The CLX Platform's Push Notification system allows you to send rich, targeted messages to your mobile app users. Whether it's a promotional offer, a system update, or a personalized alert, our system handles it all.</p>
                                
                                <div class="checklist">
                                    <h6><i class="fas fa-star text-warning"></i> Key Features:</h6>
                                    <ul class="list-unstyled mb-0">
                                        <li><i class="fas fa-check-circle text-success"></i> Rich Media Support (Images)</li>
                                        <li><i class="fas fa-check-circle text-success"></i> Advanced Targeting (User, Location)</li>
                                        <li><i class="fas fa-check-circle text-success"></i> Real-time Delivery</li>
                                        <li><i class="fas fa-check-circle text-success"></i> Campaign History</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-md-end">
                                    <a href="{{ route('admin.notifications.create') }}" class="btn btn-doc">
                                        <i class="fas fa-paper-plane"></i> Send Notification
                                    </a>
                                    <a href="{{ route('docs.index') }}" class="btn btn-outline-primary mt-2">
                                        <i class="fas fa-arrow-left"></i> Back to Documentation
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>📣 Creating a Campaign</h3>
                        <div class="step">
                            <div class="step-number">1</div>
                            <h5>Compose Message</h5>
                            <p>Go to <strong>Marketing → Push Notifications → Create New</strong>.</p>
                            <ul>
                                <li><strong>Title:</strong> Keep it short and catchy (max 40 chars recommended).</li>
                                <li><strong>Body:</strong> The main message content. be clear and concise.</li>
                                <li><strong>Image (Optional):</strong> Upload a banner image (recommended size: 1024x512px).</li>
                            </ul>
                        </div>

                        <div class="step">
                            <div class="step-number">2</div>
                            <h5>Select Target Audience</h5>
                            <p>Choose who receives your message using our advanced targeting options:</p>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="card h-100 border-0 bg-light">
                                        <div class="card-body text-center">
                                            <i class="fas fa-users fa-2x text-primary mb-3"></i>
                                            <h6>All Users</h6>
                                            <p class="small text-muted">Send to every registered user with the app installed.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card h-100 border-0 bg-light">
                                        <div class="card-body text-center">
                                            <i class="fas fa-user fa-2x text-success mb-3"></i>
                                            <h6>Specific User</h6>
                                            <p class="small text-muted">Search and select a specific user by name or email.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="card h-100 border-0 bg-light">
                                        <div class="card-body text-center">
                                            <i class="fas fa-map-marker-alt fa-2x text-danger mb-3"></i>
                                            <h6>Location</h6>
                                            <p class="small text-muted">Target users in a specific City, State, or Country.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step">
                            <div class="step-number">3</div>
                            <h5>Send & Monitor</h5>
                            <p>Review your campaign details and hit <strong>Send Notification</strong>. You can track delivery status in the notifications list.</p>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>💡 Best Practices</h3>
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Do's</h5>
                                <ul>
                                    <li>Use emojis to increase open rates 🚀</li>
                                    <li>Personalize messages when possible</li>
                                    <li>Send at appropriate local times</li>
                                    <li>Use high-quality images</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5>Don'ts</h5>
                                <ul>
                                    <li>Don't spam users frequently</li>
                                    <li>Avoid misleading clickbait titles</li>
                                    <li>Don't send late at night</li>
                                    <li>Don't forget to test before sending to all</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-md-6">
                        <a href="{{ route('admin.notifications.create') }}" class="btn btn-doc btn-lg w-100">
                            <i class="fas fa-paper-plane"></i> Create Campaign Now
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="{{ route('docs.deployment') }}" class="btn btn-outline-primary btn-lg w-100">
                            <i class="fas fa-rocket"></i> Next: Deployment Guide
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
