<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation Guide - CLX Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .doc-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .step {
            border-left: 4px solid #667eea;
            padding-left: 20px;
            margin-bottom: 2rem;
        }
        .step-number {
            background: #667eea;
            color: white;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 1rem;
        }
        .code-block {
            background: #1f2937;
            color: #f9fafb;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
        }
        .checklist {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin: 1rem 0;
        }
        .btn-doc {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="text-center mb-5">
                    <h1 class="text-white">🚀 Installation Guide</h1>
                    <p class="text-white-50">Complete step-by-step instructions to get your CLX Platform up and running</p>
                </div>

                <div class="card doc-card border-0">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-md-8">
                                <h3>📋 Overview</h3>
                                <p>The CLX Premium Classifieds Platform installation is designed to be simple and straightforward. Whether you're deploying to shared hosting, VPS, or cloud providers, this guide will walk you through every step.</p>
                                
                                <div class="checklist">
                                    <h6><i class="fas fa-check-circle text-success"></i> What You'll Need:</h6>
                                    <ul class="list-unstyled mb-0">
                                        <li><i class="fas fa-server"></i> Web server with PHP 8.0+</li>
                                        <li><i class="fas fa-database"></i> MySQL 5.7+ or MariaDB 10.3+</li>
                                        <li><i class="fas fa-terminal"></i> Composer (PHP dependency manager)</li>
                                        <li><i class="fas fa-globe"></i> Domain name (optional for live deployment)</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-md-end">
                                    <a href="/install" class="btn btn-doc">
                                        <i class="fas fa-rocket"></i> Start Installation
                                    </a>
                                    <a href="/docs" class="btn btn-outline-primary mt-2">
                                        <i class="fas fa-arrow-left"></i> Back to Documentation
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>🔧 Step 1: Upload Files</h3>
                        <div class="step">
                            <div class="step-number">1</div>
                            <h5>Upload Backend Files</h5>
                            <p>Copy the <strong>clx_backend</strong> folder to your web server. This folder contains all the Laravel backend files needed for your platform.</p>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>📁 File Structure:</h6>
                                    <div class="code-block">
clx_backend/
├── app/           # Laravel application logic
├── config/        # Configuration files
├── database/      # Migrations and seeders
├── public/        # Web server entry point
├── resources/     # Views and assets
├── routes/        # API and web routes
└── storage/       # File storage
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>🌐 Upload Methods:</h6>
                                    <ul>
                                        <li><strong>FTP:</strong> Upload clx_backend folder to public_html/</li>
                                        <li><strong>cPanel:</strong> Use File Manager to upload files</li>
                                        <li><strong>SSH:</strong> Use scp or rsync for secure transfer</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <h3>⚙️ Step 2: Configure Web Server</h3>
                        <div class="step">
                            <div class="step-number">2</div>
                            <h5>Set Document Root</h5>
                            <p>Configure your web server to point to the <code>clx_backend/public</code> directory.</p>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Apache Configuration:</h6>
                                    <div class="code-block">
# .htaccess (already included)
# DocumentRoot: /path/to/clx_backend/public
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Nginx Configuration:</h6>
                                    <div class="code-block">
server {
    listen 80;
    server_name yourdomain.com;
    root /path/to/clx_backend/public;
    index index.php;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <h3>🗄️ Step 3: Database Setup</h3>
                        <div class="step">
                            <div class="step-number">3</div>
                            <h5>Create Database</h5>
                            <p>Create a new MySQL database and user for your CLX Platform.</p>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>MySQL Commands:</h6>
                                    <div class="code-block">
CREATE DATABASE clx_platform;
CREATE USER 'clx_user'@'localhost' IDENTIFIED BY 'your_password';
GRANT ALL PRIVILEGES ON clx_platform.* TO 'clx_user'@'localhost';
FLUSH PRIVILEGES;
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Database Details Needed:</h6>
                                    <ul>
                                        <li>Database host (usually localhost)</li>
                                        <li>Database name (e.g., clx_platform)</li>
                                        <li>Database username</li>
                                        <li>Database password</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <h3>🚀 Step 4: Run Installation Wizard</h3>
                        <div class="step">
                            <div class="step-number">4</div>
                            <h5>Complete Setup</h5>
                            <p>Visit your installation URL and follow the wizard.</p>
                            
                            <div class="row">
                                <div class="col-md-8">
                                    <h6>Installation URL:</h6>
                                    <div class="code-block">
http://yourdomain.com/install
                                    </div>
                                    
                                    <h6>Steps in Wizard:</h6>
                                    <ol>
                                        <li><strong>System Requirements:</strong> Verify PHP version and extensions</li>
                                        <li><strong>Database Configuration:</strong> Enter database details</li>
                                        <li><strong>Admin Setup:</strong> Create admin account</li>
                                        <li><strong>Complete:</strong> Installation summary</li>
                                    </ol>
                                </div>
                                <div class="col-md-4">
                                    <div class="checklist">
                                        <h6><i class="fas fa-info-circle"></i> Tips:</h6>
                                        <ul class="list-unstyled mb-0">
                                            <li>Keep admin credentials secure</li>
                                            <li>Use strong database passwords</li>
                                            <li>Test database connection before proceeding</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <h3>🔒 Step 5: Security & Permissions</h3>
                        <div class="step">
                            <div class="step-number">5</div>
                            <h5>Set File Permissions</h5>
                            <p>Ensure proper file permissions for security and functionality.</p>
                            
                            <div class="code-block">
# Set permissions (run from clx_backend directory)
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
chmod 644 .env
                                    </div>
                        </div>

                        <h3>🌐 Step 6: Live Deployment</h3>
                        <div class="step">
                            <div class="step-number">6</div>
                            <h5>Production Configuration</h5>
                            <p>Configure your platform for production use.</p>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Environment Variables:</h6>
                                    <div class="code-block">
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>SSL/HTTPS:</h6>
                                    <ul>
                                        <li>Install SSL certificate</li>
                                        <li>Configure HTTPS redirect</li>
                                        <li>Update APP_URL to use https://</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="alert alert-info">
                            <h6><i class="fas fa-lightbulb"></i> Pro Tips:</h6>
                            <ul class="mb-0">
                                <li><strong>Backup:</strong> Always backup your files and database before installation</li>
                                <li><strong>Testing:</strong> Test your installation on a staging environment first</li>
                                <li><strong>Monitoring:</strong> Set up monitoring for your live site</li>
                                <li><strong>Updates:</strong> Keep your platform updated with security patches</li>
                            </ul>
                        </div>

                        <div class="row mt-4">
                            <div class="col-md-6">
                                <a href="/install" class="btn btn-doc btn-lg w-100">
                                    <i class="fas fa-play"></i> Start Installation Now
                                </a>
                            </div>
                            <div class="col-md-6">
                                <a href="/docs/admin" class="btn btn-outline-primary btn-lg w-100">
                                    <i class="fas fa-tachometer-alt"></i> Next: Admin Guide
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
