<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Documentation - CLX Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .doc-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
            transition: transform 0.3s ease;
        }
        .doc-card:hover {
            transform: translateY(-5px);
        }
        .doc-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        .btn-doc {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
        }
        .feature-list {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 1.5rem;
            margin: 1rem 0;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="text-center mb-5">
                    <h1 class="text-white">📚 CLX Platform Documentation</h1>
                    <p class="text-white-50">Complete guide to installing, configuring, and managing your CLX Premium Classifieds Platform</p>
                </div>

                <div class="row">
                    <!-- Installation Guide -->
                    <div class="col-md-6 mb-4">
                        <div class="card doc-card border-0 h-100">
                            <div class="card-body text-center p-4">
                                <div class="doc-icon text-primary">
                                    <i class="fas fa-rocket"></i>
                                </div>
                                <h4>🚀 Installation Guide</h4>
                                <p class="text-muted">Step-by-step instructions to get your CLX Platform up and running on any server.</p>
                                <div class="feature-list">
                                    <h6>What you'll learn:</h6>
                                    <ul class="list-unstyled mb-0">
                                        <li><i class="fas fa-check text-success"></i> System requirements</li>
                                        <li><i class="fas fa-check text-success"></i> Database setup</li>
                                        <li><i class="fas fa-check text-success"></i> Admin configuration</li>
                                        <li><i class="fas fa-check text-success"></i> Live deployment</li>
                                    </ul>
                                </div>
                                <a href="{{ route('docs.installation') }}" class="btn btn-doc w-100">
                                    <i class="fas fa-book"></i> Read Installation Guide
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Admin Guide -->
                    <div class="col-md-6 mb-4">
                        <div class="card doc-card border-0 h-100">
                            <div class="card-body text-center p-4">
                                <div class="doc-icon text-info">
                                    <i class="fas fa-tachometer-alt"></i>
                                </div>
                                <h4>⚙️ Admin Management</h4>
                                <p class="text-muted">Complete guide to managing users, ads, categories, and platform settings.</p>
                                <div class="feature-list">
                                    <h6>What you'll learn:</h6>
                                    <ul class="list-unstyled mb-0">
                                        <li><i class="fas fa-check text-success"></i> User management</li>
                                        <li><i class="fas fa-check text-success"></i> Ad moderation</li>
                                        <li><i class="fas fa-check text-success"></i> Category setup</li>
                                        <li><i class="fas fa-check text-success"></i> Security settings</li>
                                    </ul>
                                </div>
                                <a href="{{ route('docs.admin') }}" class="btn btn-doc w-100">
                                    <i class="fas fa-cog"></i> Read Admin Guide
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Push Notifications -->
                    <div class="col-md-6 mb-4">
                        <div class="card doc-card border-0 h-100">
                            <div class="card-body text-center p-4">
                                <div class="doc-icon text-warning">
                                    <i class="fas fa-bell"></i>
                                </div>
                                <h4>🔔 Push Notifications</h4>
                                <p class="text-muted">Master the advanced push notification system for maximum user engagement.</p>
                                <div class="feature-list">
                                    <h6>What you'll learn:</h6>
                                    <ul class="list-unstyled mb-0">
                                        <li><i class="fas fa-check text-success"></i> Template creation</li>
                                        <li><i class="fas fa-check text-success"></i> Targeted campaigns</li>
                                        <li><i class="fas fa-check text-success"></i> Scheduling & automation</li>
                                        <li><i class="fas fa-check text-success"></i> Analytics & optimization</li>
                                    </ul>
                                </div>
                                <a href="{{ route('docs.notifications') }}" class="btn btn-doc w-100">
                                    <i class="fas fa-bell"></i> Read Notifications Guide
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Deployment Guide -->
                    <div class="col-md-6 mb-4">
                        <div class="card doc-card border-0 h-100">
                            <div class="card-body text-center p-4">
                                <div class="doc-icon text-success">
                                    <i class="fas fa-cloud"></i>
                                </div>
                                <h4>☁️ Deployment Guide</h4>
                                <p class="text-muted">Deploy your CLX Platform to shared hosting, VPS, or cloud providers.</p>
                                <div class="feature-list">
                                    <h6>What you'll learn:</h6>
                                    <ul class="list-unstyled mb-0">
                                        <li><i class="fas fa-check text-success"></i> Shared hosting setup</li>
                                        <li><i class="fas fa-check text-success"></i> VPS configuration</li>
                                        <li><i class="fas fa-check text-success"></i> Cloud deployment</li>
                                        <li><i class="fas fa-check text-success"></i> Performance optimization</li>
                                    </ul>
                                </div>
                                <a href="{{ route('docs.deployment') }}" class="btn btn-doc w-100">
                                    <i class="fas fa-rocket"></i> Read Deployment Guide
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- API Documentation -->
                    <div class="col-md-6 mb-4">
                        <div class="card doc-card border-0 h-100">
                            <div class="card-body text-center p-4">
                                <div class="doc-icon text-danger">
                                    <i class="fas fa-code"></i>
                                </div>
                                <h4>💻 API Documentation</h4>
                                <p class="text-muted">Complete API reference for mobile app integration and custom development.</p>
                                <div class="feature-list">
                                    <h6>What you'll learn:</h6>
                                    <ul class="list-unstyled mb-0">
                                        <li><i class="fas fa-check text-success"></i> RESTful API endpoints</li>
                                        <li><i class="fas fa-check text-success"></i> Authentication methods</li>
                                        <li><i class="fas fa-check text-success"></i> Mobile app integration</li>
                                        <li><i class="fas fa-check text-success"></i> Custom development</li>
                                    </ul>
                                </div>
                                <a href="{{ route('docs.api') }}" class="btn btn-doc w-100">
                                    <i class="fas fa-code"></i> Read API Documentation
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Start -->
                    <div class="col-md-6 mb-4">
                        <div class="card doc-card border-0 h-100">
                            <div class="card-body text-center p-4">
                                <div class="doc-icon text-secondary">
                                    <i class="fas fa-play"></i>
                                </div>
                                <h4>⚡ Quick Start</h4>
                                <p class="text-muted">Get started quickly with essential setup and configuration steps.</p>
                                <div class="feature-list">
                                    <h6>What you'll learn:</h6>
                                    <ul class="list-unstyled mb-0">
                                        <li><i class="fas fa-check text-success"></i> 5-minute setup</li>
                                        <li><i class="fas fa-check text-success"></i> Essential configurations</li>
                                        <li><i class="fas fa-check text-success"></i> First ad posting</li>
                                        <li><i class="fas fa-check text-success"></i> User registration</li>
                                    </ul>
                                </div>
                                <a href="{{ route('install.welcome') }}" class="btn btn-doc w-100">
                                    <i class="fas fa-play"></i> Start Installation
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-md-8">
                                <h5>💡 Need Help?</h5>
                                <p class="text-muted mb-0">
                                    If you encounter any issues during installation or setup, refer to our comprehensive guides above.
                                    Each section includes troubleshooting tips and best practices.
                                </p>
                            </div>
                            <div class="col-md-4 text-md-end">
                                <a href="/admin" class="btn btn-outline-primary">
                                    <i class="fas fa-tachometer-alt"></i> Go to Admin Dashboard
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
