<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deployment Guide - CLX Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .doc-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .deployment-option {
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }
        .deployment-option:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .btn-doc {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="text-center mb-5">
                    <h1 class="text-white">☁️ Deployment Guide</h1>
                    <p class="text-white-50">Deploy your CLX Platform to shared hosting, VPS, or cloud providers</p>
                </div>

                <div class="card doc-card border-0">
                    <div class="card-body p-4">
                        <h3>📋 Overview</h3>
                        <p>The CLX Platform can be deployed to various hosting environments. This guide covers deployment to shared hosting, VPS, and cloud providers with step-by-step instructions for each option.</p>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="deployment-option">
                                    <h5><i class="fas fa-building text-primary"></i> Shared Hosting</h5>
                                    <p>Best for beginners and small-scale deployments. Easy setup with cPanel.</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="deployment-option">
                                    <h5><i class="fas fa-server text-info"></i> VPS/Dedicated</h5>
                                    <p>Full control over server configuration. Best for medium to large deployments.</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="deployment-option">
                                    <h5><i class="fas fa-cloud text-success"></i> Cloud Providers</h5>
                                    <p>Scalable and flexible. AWS, Google Cloud, Azure, DigitalOcean, etc.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>🏠 Shared Hosting (cPanel) Deployment</h3>
                        <p class="mb-4">Follow this comprehensive guide to deploy CLX Platform on cPanel shared hosting securely and correctly.</p>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <h5>Step 1: Preparation (Local Machine)</h5>
                                <ol class="mb-4">
                                    <li><strong>Clean Install:</strong> ensure your local project is working and up to date.</li>
                                    <li><strong>Optimize:</strong> Run the following commands to optimize for production:
                                        <div class="bg-light p-2 rounded mt-2 font-monospace">
                                            composer install --optimize-autoloader --no-dev<br>
                                            php artisan config:cache<br>
                                            php artisan route:cache<br>
                                            php artisan view:cache
                                        </div>
                                    </li>
                                    <li><strong>Zip Files:</strong> Compress your entire project folder (excluding <code>node_modules</code> and <code>.git</code>) into a zip file named <code>clx_project.zip</code>.</li>
                                </ol>

                                <h5>Step 2: Database Setup (cPanel)</h5>
                                <ol class="mb-4">
                                    <li>Log in to cPanel and go to <strong>MySQL® Database Wizard</strong>.</li>
                                    <li>Create a new database (e.g., <code>youruser_clxdb</code>).</li>
                                    <li>Create a new user (e.g., <code>youruser_clxuser</code>) and generate a strong password. <strong>Save these details!</strong></li>
                                    <li>Assign the user to the database and grant <strong>ALL PRIVILEGES</strong>.</li>
                                    <li>Go to <strong>phpMyAdmin</strong>, select your new database, and Import your local database dump (<code>.sql</code> file) if you haven't run migrations on the server.</li>
                                </ol>

                                <h5>Step 3: Uploading Files (File Manager)</h5>
                                <ol class="mb-4">
                                    <li>Go to <strong>File Manager</strong> in cPanel.</li>
                                    <li><strong>Security Best Practice:</strong> We will separate the core code from the public files.
                                        <ul>
                                            <li>Navigate to the root directory (<code>/home/yourusername/</code>), <strong>NOT</strong> <code>public_html</code>.</li>
                                            <li>Create a new folder named <code>clx_core</code>.</li>
                                            <li>Upload <code>clx_project.zip</code> into <code>clx_core</code> and extract it.</li>
                                        </ul>
                                    </li>
                                </ol>

                                <h5>Step 4: Configuring Public Access</h5>
                                <ol class="mb-4">
                                    <li>Navigate to <code>/home/yourusername/clx_core/public</code>.</li>
                                    <li>Select all files and folder, and <strong>Move</strong> them to <code>/home/yourusername/public_html</code>.</li>
                                    <li>Go to <code>public_html</code> and edit <code>index.php</code>:
                                        <div class="bg-light p-3 rounded mt-2 mb-2 font-monospace">
                                            // Find these lines:<br>
                                            require __DIR__.'/../vendor/autoload.php';<br>
                                            $app = require_once __DIR__.'/../bootstrap/app.php';<br><br>

                                            // Change them to point to your clx_core folder:<br>
                                            require __DIR__.'/../clx_core/vendor/autoload.php';<br>
                                            $app = require_once __DIR__.'/../clx_core/bootstrap/app.php';
                                        </div>
                                    </li>
                                </ol>

                                <h5>Step 5: Environment Configuration</h5>
                                <ol class="mb-4">
                                    <li>Go to <code>/home/yourusername/clx_core/</code> and edit the <code>.env</code> file.</li>
                                    <li>Update database credentials:
                                        <div class="bg-light p-2 rounded mt-2 font-monospace">
                                            DB_DATABASE=youruser_clxdb<br>
                                            DB_USERNAME=youruser_clxuser<br>
                                            DB_PASSWORD=your_strong_password
                                        </div>
                                    </li>
                                    <li>Set <code>APP_URL=https://yourdomain.com</code></li>
                                    <li>Set <code>APP_ENV=production</code> and <code>APP_DEBUG=false</code></li>
                                </ol>

                                <h5>Step 6: Storage Link & Permissions</h5>
                                <div class="alert alert-info">
                                    <strong>Important:</strong> On shared hosting without SSH, you can create the storage link using a PHP script or Cron job.
                                </div>
                                <ul>
                                    <li><strong>Permissions:</strong> Ensure <code>clx_core/storage</code> and <code>clx_core/bootstrap/cache</code> are writable (Client 775 or 755).</li>
                                    <li><strong>Symlink Method:</strong> Create a temporary PHP file in <code>public_html/link.php</code>:
                                        <div class="bg-light p-2 rounded mt-2 font-monospace">
                                            &lt;?php<br>
                                            symlink('/home/yourusername/clx_core/storage/app/public', '/home/yourusername/public_html/storage');<br>
                                            echo "Link created";
                                        </div>
                                    </li>
                                    <li>Visit <code>yourdomain.com/link.php</code> once, then delete it.</li>
                                </ul>

                                <h5>Step 7: Cron Job Setup</h5>
                                <p>To ensure notifications and scheduled tasks run, set up a cron job:</p>
                                <ol>
                                    <li>Go to <strong>Cron Jobs</strong> in cPanel.</li>
                                    <li>Add a new cron job to run every minute (<code>* * * * *</code>):</li>
                                    <li>Command:
                                        <div class="bg-light p-2 rounded mt-2 font-monospace">
                                            /usr/local/bin/php /home/yourusername/clx_core/artisan schedule:run >> /dev/null 2>&1
                                        </div>
                                        <small class="text-muted">(Check your hosting provider for the correct PHP path, mostly <code>/usr/local/bin/php</code> or <code>php</code>)</small>
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>🖥️ VPS/Dedicated Server Deployment</h3>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Server Requirements</h5>
                                <ul>
                                    <li>Ubuntu 20.04+ or CentOS 8+</li>
                                    <li>PHP 8.0+ with required extensions</li>
                                    <li>MySQL 5.7+ or MariaDB 10.3+</li>
                                    <li>Web server (Apache/Nginx)</li>
                                    <li>Composer for dependency management</li>
                                </ul>
                                
                                <h5>Installation Commands</h5>
                                <div class="code-block">
# Update system
sudo apt update && sudo apt upgrade -y

# Install LAMP stack (Ubuntu)
sudo apt install apache2 mysql-server php8.1 php8.1-mysql php8.1-curl php8.1-mbstring php8.1-xml php8.1-zip

# Install Composer
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer

# Configure database
sudo mysql_secure_installation
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="deployment-option">
                                    <h6><i class="fas fa-terminal"></i> Common Commands:</h6>
                                    <ul class="list-unstyled">
                                        <li>composer install</li>
                                        <li>php artisan migrate</li>
                                        <li>php artisan key:generate</li>
                                        <li>chmod -R 755 storage/</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>☁️ Cloud Provider Deployment</h3>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Amazon Web Services (AWS)</h5>
                                <ul>
                                    <li>Use EC2 for compute instances</li>
                                    <li>RDS for managed MySQL database</li>
                                    <li>S3 for file storage</li>
                                    <li>CloudFront for CDN</li>
                                    <li>Route 53 for DNS management</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5>Google Cloud Platform (GCP)</h5>
                                <ul>
                                    <li>Compute Engine for VM instances</li>
                                    <li>Cloud SQL for managed database</li>
                                    <li>Cloud Storage for file storage</li>
                                    <li>Cloud CDN for content delivery</li>
                                    <li>Cloud DNS for domain management</li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <h5>Microsoft Azure</h5>
                                <ul>
                                    <li>Virtual Machines for compute</li>
                                    <li>Azure Database for MySQL</li>
                                    <li>Storage Accounts for files</li>
                                    <li>Content Delivery Network</li>
                                    <li>Azure DNS for domain management</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5>DigitalOcean</h5>
                                <ul>
                                    <li>Droplets for compute instances</li>
                                    <li>Managed Databases for MySQL</li>
                                    <li>Spaces for object storage</li>
                                    <li>CDN for content delivery</li>
                                    <li>Domains for DNS management</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>🔒 Security & Performance</h3>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Security Measures</h5>
                                <ul>
                                    <li><strong>SSL/HTTPS:</strong> Install SSL certificate for secure connections</li>
                                    <li><strong>Firewall:</strong> Configure firewall rules to restrict access</li>
                                    <li><strong>Updates:</strong> Keep system and dependencies updated</li>
                                    <li><strong>Backups:</strong> Set up automated database and file backups</li>
                                    <li><strong>Monitoring:</strong> Implement security monitoring and alerts</li>
                                </ul>
                                
                                <h5>Performance Optimization</h5>
                                <ul>
                                    <li><strong>Caching:</strong> Enable Redis or Memcached for caching</li>
                                    <li><strong>OPcache:</strong> Enable PHP OPcache for better performance</li>
                                    <li><strong>CDN:</strong> Use CDN for static assets</li>
                                    <li><strong>Database:</strong> Optimize database queries and indexes</li>
                                    <li><strong>Compression:</strong> Enable gzip compression</li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <div class="alert alert-warning">
                                    <h6><i class="fas fa-shield-alt"></i> Security First:</h6>
                                    <ul class="mb-0">
                                        <li>Use strong passwords</li>
                                        <li>Enable two-factor authentication</li>
                                        <li>Regular security audits</li>
                                        <li>Monitor for suspicious activity</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>🚀 Post-Deployment Checklist</h3>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Essential Checks</h5>
                                <ul>
                                    <li>✅ Website loads correctly</li>
                                    <li>✅ Admin dashboard accessible</li>
                                    <li>✅ Database connection working</li>
                                    <li>✅ File uploads functional</li>
                                    <li>✅ SSL certificate active</li>
                                    <li>✅ Email sending working</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5>Performance Tests</h5>
                                <ul>
                                    <li>✅ Page load speed acceptable</li>
                                    <li>✅ Database queries optimized</li>
                                    <li>✅ Caching working properly</li>
                                    <li>✅ Mobile responsiveness</li>
                                    <li>✅ Browser compatibility</li>
                                    <li>✅ API response times</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-md-6">
                        <a href="/install" class="btn btn-doc btn-lg w-100">
                            <i class="fas fa-rocket"></i> Start Installation
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="/docs/api" class="btn btn-outline-primary btn-lg w-100">
                            <i class="fas fa-code"></i> Next: API Documentation
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
