<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Documentation - CLX Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .doc-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .api-endpoint {
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }
        .api-endpoint:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .code-block {
            background: #1f2937;
            color: #f9fafb;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
            margin: 1rem 0;
        }
        .method-badge {
            font-size: 0.8rem;
            padding: 4px 8px;
            border-radius: 6px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .method-get { background: #10b981; color: white; }
        .method-post { background: #3b82f6; color: white; }
        .method-put { background: #f59e0b; color: white; }
        .method-delete { background: #ef4444; color: white; }
        .btn-doc {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="text-center mb-5">
                    <h1 class="text-white">💻 API Documentation</h1>
                    <p class="text-white-50">Complete API reference for mobile app integration and custom development</p>
                </div>

                <div class="card doc-card border-0">
                    <div class="card-body p-4">
                        <h3>📋 Overview</h3>
                        <p>The CLX Platform provides a comprehensive RESTful API for mobile app integration and custom development. All API endpoints follow REST conventions and return JSON responses.</p>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Base URL</h5>
                                <div class="code-block">
https://yourdomain.com/api/v1
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h5>Authentication</h5>
                                <p>All API requests require authentication using Bearer tokens:</p>
                                <div class="code-block">
Authorization: Bearer {your_api_token}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>🔐 Authentication API</h3>
                        
                        <div class="api-endpoint">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">User Registration</h5>
                                <span class="method-badge method-post">POST</span>
                            </div>
                            <p class="text-muted mb-3">Register a new user account</p>
                            <div class="code-block">
POST /api/v1/auth/register
Content-Type: application/json

{
    "name": "John Doe",
    "email": "john@example.com",
    "password": "password123",
    "password_confirmation": "password123"
}
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Response:</h6>
                                    <div class="code-block">
{
    "success": true,
    "message": "User registered successfully",
    "data": {
        "user": {
            "id": 1,
            "name": "John Doe",
            "email": "john@example.com",
            "plan": "Standard"
        },
        "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9..."
    }
}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Required Fields:</h6>
                                    <ul>
                                        <li>name (string)</li>
                                        <li>email (string, valid email)</li>
                                        <li>password (string, min 8 chars)</li>
                                        <li>password_confirmation (string)</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="api-endpoint">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">User Login</h5>
                                <span class="method-badge method-post">POST</span>
                            </div>
                            <p class="text-muted mb-3">Authenticate user and get access token</p>
                            <div class="code-block">
POST /api/v1/auth/login
Content-Type: application/json

{
    "email": "john@example.com",
    "password": "password123"
}
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Response:</h6>
                                    <div class="code-block">
{
    "success": true,
    "message": "Login successful",
    "data": {
        "user": {
            "id": 1,
            "name": "John Doe",
            "email": "john@example.com",
            "plan": "Standard"
        },
        "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9..."
    }
}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Required Fields:</h6>
                                    <ul>
                                        <li>email (string, valid email)</li>
                                        <li>password (string)</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>📋 Ads API</h3>
                        
                        <div class="api-endpoint">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">Get All Ads</h5>
                                <span class="method-badge method-get">GET</span>
                            </div>
                            <p class="text-muted mb-3">Retrieve paginated list of ads with filtering options</p>
                            <div class="code-block">
GET /api/v1/ads?page=1&category=vehicles&location=Mumbai&search=car
Authorization: Bearer {your_api_token}
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Query Parameters:</h6>
                                    <ul>
                                        <li>page (integer, optional)</li>
                                        <li>category (string, optional)</li>
                                        <li>location (string, optional)</li>
                                        <li>search (string, optional)</li>
                                        <li>sort (string, optional)</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6>Response:</h6>
                                    <div class="code-block">
{
    "success": true,
    "data": {
        "ads": [
            {
                "id": 1,
                "title": "Toyota Corolla",
                "description": "Well maintained car",
                "price": 500000,
                "category": "Vehicles",
                "location": "Mumbai",
                "images": [...],
                "user": {...}
            }
        ],
        "pagination": {
            "current_page": 1,
            "total": 100,
            "per_page": 10
        }
    }
}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="api-endpoint">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">Create Ad</h5>
                                <span class="method-badge method-post">POST</span>
                            </div>
                            <p class="text-muted mb-3">Create a new classified ad</p>
                            <div class="code-block">
POST /api/v1/ads
Authorization: Bearer {your_api_token}
Content-Type: multipart/form-data

title: "iPhone 13"
description: "Brand new iPhone"
price: 60000
category_id: 5
location: "Delhi"
images[]: [file1, file2, file3]
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Response:</h6>
                                    <div class="code-block">
{
    "success": true,
    "message": "Ad created successfully",
    "data": {
        "ad": {
            "id": 123,
            "title": "iPhone 13",
            "description": "Brand new iPhone",
            "price": 60000,
            "status": "pending"
        }
    }
}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Required Fields:</h6>
                                    <ul>
                                        <li>title (string)</li>
                                        <li>description (string)</li>
                                        <li>price (numeric)</li>
                                        <li>category_id (integer)</li>
                                        <li>location (string)</li>
                                        <li>images[] (array of files, optional)</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>👥 User API</h3>
                        
                        <div class="api-endpoint">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">Get User Profile</h5>
                                <span class="method-badge method-get">GET</span>
                            </div>
                            <p class="text-muted mb-3">Retrieve current user's profile information</p>
                            <div class="code-block">
GET /api/v1/user/profile
Authorization: Bearer {your_api_token}
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Response:</h6>
                                    <div class="code-block">
{
    "success": true,
    "data": {
        "user": {
            "id": 1,
            "name": "John Doe",
            "email": "john@example.com",
            "phone": "+919876543210",
            "location": "Mumbai",
            "plan": "VIP Pro",
            "ads_count": 15,
            "trust_score": 85
        }
    }
}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Available Data:</h6>
                                    <ul>
                                        <li>User basic information</li>
                                        <li>Subscription plan</li>
                                        <li>Ad statistics</li>
                                        <li>Trust score</li>
                                        <li>Contact information</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="api-endpoint">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">Update Profile</h5>
                                <span class="method-badge method-put">PUT</span>
                            </div>
                            <p class="text-muted mb-3">Update user profile information</p>
                            <div class="code-block">
PUT /api/v1/user/profile
Authorization: Bearer {your_api_token}
Content-Type: multipart/form-data

name: "John Smith"
phone: "+919876543210"
location: "Delhi"
avatar: [file]
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Response:</h6>
                                    <div class="code-block">
{
    "success": true,
    "message": "Profile updated successfully",
    "data": {
        "user": {
            "id": 1,
            "name": "John Smith",
            "email": "john@example.com",
            "phone": "+919876543210",
            "location": "Delhi"
        }
    }
}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Optional Fields:</h6>
                                    <ul>
                                        <li>name (string)</li>
                                        <li>phone (string)</li>
                                        <li>location (string)</li>
                                        <li>avatar (file, optional)</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>📁 Categories API</h3>
                        
                        <div class="api-endpoint">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">Get Categories</h5>
                                <span class="method-badge method-get">GET</span>
                            </div>
                            <p class="text-muted mb-3">Retrieve all available categories and subcategories</p>
                            <div class="code-block">
GET /api/v1/categories
Authorization: Bearer {your_api_token}
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Response:</h6>
                                    <div class="code-block">
{
    "success": true,
    "data": {
        "categories": [
            {
                "id": 1,
                "name": "Vehicles",
                "icon": "🚗",
                "subcategories": [
                    {
                        "id": 5,
                        "name": "Cars",
                        "parent_id": 1
                    }
                ]
            }
        ]
    }
}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Category Structure:</h6>
                                    <ul>
                                        <li>Category ID and name</li>
                                        <li>Icon representation</li>
                                        <li>Subcategory hierarchy</li>
                                        <li>Custom fields (if any)</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>📊 Analytics API</h3>
                        
                        <div class="api-endpoint">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0">Get Dashboard Stats</h5>
                                <span class="method-badge method-get">GET</span>
                            </div>
                            <p class="text-muted mb-3">Retrieve user's dashboard statistics and analytics</p>
                            <div class="code-block">
GET /api/v1/analytics/dashboard
Authorization: Bearer {your_api_token}
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Response:</h6>
                                    <div class="code-block">
{
    "success": true,
    "data": {
        "stats": {
            "total_ads": 15,
            "active_ads": 12,
            "views": 1250,
            "leads": 45,
            "conversion_rate": "3.6%"
        },
        "charts": {
            "views_trend": [...],
            "leads_trend": [...]
        }
    }
}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6>Available Metrics:</h6>
                                    <ul>
                                        <li>Total and active ads</li>
                                        <li>View and lead counts</li>
                                        <li>Conversion rates</li>
                                        <li>Trending data</li>
                                        <li>Performance insights</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>⚠️ Error Handling</h3>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Standard Error Response</h5>
                                <div class="code-block">
{
    "success": false,
    "message": "Validation failed",
    "errors": {
        "email": ["The email field is required."],
        "password": ["The password must be at least 8 characters."]
    }
}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <h5>HTTP Status Codes</h5>
                                <ul>
                                    <li><strong>200:</strong> Success</li>
                                    <li><strong>201:</strong> Created</li>
                                    <li><strong>400:</strong> Bad Request</li>
                                    <li><strong>401:</strong> Unauthorized</li>
                                    <li><strong>403:</strong> Forbidden</li>
                                    <li><strong>404:</strong> Not Found</li>
                                    <li><strong>422:</strong> Validation Error</li>
                                    <li><strong>500:</strong> Server Error</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-md-6">
                        <a href="/docs" class="btn btn-doc btn-lg w-100">
                            <i class="fas fa-book"></i> Back to Documentation
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="/docs/installation" class="btn btn-outline-primary btn-lg w-100">
                            <i class="fas fa-rocket"></i> Start Installation
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
