<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Management Guide - CLX Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .doc-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .feature-card {
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
        }
        .feature-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .btn-doc {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="text-center mb-5">
                    <h1 class="text-white">⚙️ Admin Management Guide</h1>
                    <p class="text-white-50">Complete guide to managing users, ads, categories, and platform settings</p>
                </div>

                <div class="card doc-card border-0">
                    <div class="card-body p-4">
                        <h3>📋 Overview</h3>
                        <p>The CLX Platform admin dashboard provides comprehensive tools for managing your classifieds business. This guide covers all aspects of platform administration.</p>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="feature-card">
                                    <h5><i class="fas fa-users text-primary"></i> User Management</h5>
                                    <p>View, manage, and moderate user accounts. Handle registrations, verify identities, and manage user roles and permissions.</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="feature-card">
                                    <h5><i class="fas fa-ad text-info"></i> Ad Moderation</h5>
                                    <p>Review, approve, and manage classified ads. Handle reports, enforce policies, and maintain content quality.</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="feature-card">
                                    <h5><i class="fas fa-sitemap text-success"></i> Category Setup</h5>
                                    <p>Create and organize ad categories and subcategories. Manage the platform's classification structure.</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="feature-card">
                                    <h5><i class="fas fa-shield-alt text-warning"></i> Security Settings</h5>
                                    <p>Configure platform security, manage safety reports, and handle user trust scores and banning.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>👥 User Management</h3>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Viewing Users</h5>
                                <p>Navigate to <strong>Admin → Users</strong> to see all registered users. You can filter by:</p>
                                <ul>
                                    <li>User status (Active, Pending, Banned)</li>
                                    <li>User plan (Standard, VIP Buyer, VIP Seller, VIP Pro)</li>
                                    <li>Registration date</li>
                                    <li>Last activity</li>
                                </ul>
                                
                                <h5>User Actions</h5>
                                <ul>
                                    <li><strong>View Profile:</strong> See complete user information</li>
                                    <li><strong>Edit:</strong> Update user details and settings</li>
                                    <li><strong>Suspend:</strong> Temporarily disable user account</li>
                                    <li><strong>Ban:</strong> Permanently ban user for violations</li>
                                    <li><strong>Verify:</strong> Mark user as verified</li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <div class="alert alert-info">
                                    <h6><i class="fas fa-lightbulb"></i> Pro Tip:</h6>
                                    <p>Use bulk actions to manage multiple users at once. Always document reasons for suspensions or bans.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>📋 Ad Moderation</h3>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Reviewing Ads</h5>
                                <p>Go to <strong>Admin → Ads</strong> to moderate classified listings:</p>
                                <ul>
                                    <li><strong>Pending:</strong> New ads awaiting approval</li>
                                    <li><strong>Active:</strong> Published and visible ads</li>
                                    <li><strong>Rejected:</strong> Ads that don't meet guidelines</li>
                                    <li><strong>Expired:</strong> Ads past their validity period</li>
                                </ul>
                                
                                <h5>Moderation Actions</h5>
                                <ul>
                                    <li><strong>Approve:</strong> Publish pending ads</li>
                                    <li><strong>Reject:</strong> Remove ads with reasons</li>
                                    <li><strong>Edit:</strong> Modify ad content</li>
                                    <li><strong>Feature:</strong> Highlight important ads</li>
                                    <li><strong>Report Handling:</strong> Review user reports</li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <div class="alert alert-warning">
                                    <h6><i class="fas fa-exclamation-triangle"></i> Important:</h6>
                                    <p>Always review ads against your platform's content policies. Be consistent in moderation decisions.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>📁 Category Management</h3>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Creating Categories</h5>
                                <p>Access <strong>Admin → Categories</strong> to organize your platform:</p>
                                <ul>
                                    <li><strong>Main Categories:</strong> Top-level classifications</li>
                                    <li><strong>Subcategories:</strong> More specific groupings</li>
                                    <li><strong>Custom Fields:</strong> Category-specific form fields</li>
                                    <li><strong>Icons:</strong> Visual representation for categories</li>
                                </ul>
                                
                                <h5>Best Practices</h5>
                                <ul>
                                    <li>Keep categories broad but meaningful</li>
                                    <li>Use clear, descriptive names</li>
                                    <li>Limit subcategory depth to 2-3 levels</li>
                                    <li>Regularly review and reorganize as needed</li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <div class="feature-card">
                                    <h6><i class="fas fa-tags"></i> Example Structure:</h6>
                                    <ul class="list-unstyled">
                                        <li>🚗 Vehicles</li>
                                        <li>🏠 Real Estate</li>
                                        <li>💼 Jobs</li>
                                        <li>🛍️ Services</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>💬 Help & Support System</h3>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Ticket Management</h5>
                                <p>Manage customer inquiries via <strong>Admin → Help & Support → Tickets</strong>:</p>
                                <ul>
                                    <li><strong>Status Tracking:</strong> Open, In Progress, Resolved, Closed</li>
                                    <li><strong>Priority Levels:</strong> High, Medium, Low prioritization</li>
                                    <li><strong>Internal Notes:</strong> Add private notes for team collaboration</li>
                                    <li><strong>Attachments:</strong> View and manage user uploaded files</li>
                                </ul>
                                
                                <h5>Live Chat Operation</h5>
                                <p>Engage with users in real-time via <strong>Admin → Help & Support → Chats</strong>:</p>
                                <ul>
                                    <li><strong>Active Chats:</strong> Monitor and respond to ongoing conversations</li>
                                    <li><strong>User Insights:</strong> View user profile and recent ads directly in chat window</li>
                                    <li><strong>Chat History:</strong> Access past conversations for context</li>
                                </ul>

                                <h5>Support Settings</h5>
                                <p>Configure your support channels in <strong>Settings</strong>:</p>
                                <ul>
                                    <li>Enable/Disable Tickets or Live Chat globally</li>
                                    <li>Set up auto-reply messages</li>
                                    <li>Configure support contact email and phone</li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <div class="feature-card bg-light">
                                    <h6><i class="fas fa-headset text-primary"></i> Support Workflow:</h6>
                                    <ol class="mb-0 small">
                                        <li>Receive Ticket/Chat</li>
                                        <li>Assign Priority</li>
                                        <li>Investigate Issue (Check User/Ads)</li>
                                        <li>Respond & Resolve</li>
                                        <li>Close Ticket/Chat</li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>🔒 Security & Safety</h3>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <h5>Safety Reports</h5>
                                <p>Monitor <strong>Admin → Safety</strong> for user reports:</p>
                                <ul>
                                    <li><strong>Report Review:</strong> Investigate reported content</li>
                                    <li><strong>User Actions:</strong> Suspend or ban offending users</li>
                                    <li><strong>Content Removal:</strong> Delete inappropriate ads</li>
                                    <li><strong>Appeals:</strong> Handle user appeals for decisions</li>
                                </ul>
                                
                                <h5>Trust Management</h5>
                                <p>Use the trust scoring system to:</p>
                                <ul>
                                    <li>Monitor user behavior patterns</li>
                                    <li>Automatically flag suspicious activity</li>
                                    <li>Implement graduated penalties</li>
                                    <li>Reward positive user behavior</li>
                                </ul>
                            </div>
                            <div class="col-md-4">
                                <div class="alert alert-danger">
                                    <h6><i class="fas fa-shield-alt"></i> Security First:</h6>
                                    <p>Always prioritize user safety. When in doubt, err on the side of caution with content moderation.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card doc-card border-0 mt-4">
                    <div class="card-body p-4">
                        <h3>⚙️ Platform Settings</h3>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5>General Settings</h5>
                                <ul>
                                    <li>Site name and branding</li>
                                    <li>Contact information</li>
                                    <li>Terms of service</li>
                                    <li>Privacy policy</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5>Advanced Settings</h5>
                                <ul>
                                    <li>Ad posting limits</li>
                                    <li>Verification requirements</li>
                                    <li>Notification preferences</li>
                                    <li>Analytics configuration</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-md-6">
                        <a href="/admin" class="btn btn-doc btn-lg w-100">
                            <i class="fas fa-tachometer-alt"></i> Go to Admin Dashboard
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="/docs/notifications" class="btn btn-outline-primary btn-lg w-100">
                            <i class="fas fa-bell"></i> Next: Push Notifications
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
