@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Chat Monitor & Safety</h1>
        <div>
            <a href="{{ route('admin.chat.index', ['flagged' => 1]) }}" class="btn btn-danger btn-sm">
                <i class="fas fa-exclamation-triangle"></i> Show Flagged Only
            </a>
            <a href="{{ route('admin.chat.index') }}" class="btn btn-secondary btn-sm">Show All</a>
        </div>
    </div>

    <!-- Stats Logs -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Total Flagged Messages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ \App\Models\ChatMessage::where('is_flagged', true)->count() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shield-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Live Chat Feed</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Time</th>
                            <th>Sender</th>
                            <th>Receiver</th>
                            <th>Message</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($messages as $msg)
                        <tr class="{{ $msg->is_flagged ? 'table-danger' : '' }}">
                            <td>{{ $msg->created_at->diffForHumans() }}</td>
                            <td>
                                <a href="{{ route('admin.users.edit', $msg->sender_id) }}" class="font-weight-bold">{{ $msg->sender->name }}</a>
                                <br>
                                <small class="text-muted">Trust: {{ $msg->sender->trustScore->score ?? 'N/A' }}</small>
                            </td>
                            <td>{{ $msg->receiver->name }}</td>
                            <td>
                                {{ Str::limit($msg->message, 50) }}
                                @if($msg->is_flagged)
                                    <div class="text-danger small mt-1">
                                        <strong>Flagged:</strong> {{ $msg->flag_reason }}
                                    </div>
                                @endif
                            </td>
                            <td>
                                @if($msg->is_flagged)
                                    <span class="badge badge-danger">High Risk</span>
                                @else
                                    <span class="badge badge-success">Clean</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.chat.conversation', ['user1' => $msg->sender_id, 'user2' => $msg->receiver_id]) }}" class="btn btn-info btn-sm">
                                    <i class="fas fa-eye"></i> View Chat
                                </a>
                                @if(!$msg->is_flagged)
                                    <form action="{{ route('admin.chat.flag', $msg->id) }}" method="POST" style="display:inline;">
                                        @csrf
                                        <input type="hidden" name="reason" value="Manual Check">
                                        <button type="submit" class="btn btn-warning btn-sm" title="Flag manually">
                                            <i class="fas fa-flag"></i>
                                        </button>
                                    </form>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-3">
                {{ $messages->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
