@extends('admin.layouts.app')

@section('title', 'Blogs')

@section('content')
<div style="margin-bottom: 24px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
        <div>
            <h2 style="margin: 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Blogs</h2>
            <p style="margin: 4px 0 0 0; color: var(--text-secondary); font-size: 14px;">Manage blog posts</p>
        </div>
        <a href="{{ route('admin.blogs.create') }}" style="padding: 10px 20px; background: var(--success-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: flex; align-items: center; gap: 8px;">
            <span>➕</span> Create Blog Post
        </a>
    </div>

    {{-- Filters --}}
    <div class="card" style="margin-bottom: 16px; padding: 16px;">
        <form method="GET" style="display: flex; gap: 12px; align-items: end;">
            <div style="flex: 1;">
                <label style="display: block; margin-bottom: 4px; font-weight: 600; font-size: 14px;">Search</label>
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Search blogs..." style="width: 100%; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
            </div>
            <div>
                <label style="display: block; margin-bottom: 4px; font-weight: 600; font-size: 14px;">Category</label>
                <select name="category" style="padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
                    <option value="">All Categories</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}" {{ request('category') == $cat->id ? 'selected' : '' }}>
                            {{ $cat->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label style="display: block; margin-bottom: 4px; font-weight: 600; font-size: 14px;">Status</label>
                <select name="status" style="padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
                    <option value="">All</option>
                    <option value="published" {{ request('status') == 'published' ? 'selected' : '' }}>Published</option>
                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                </select>
            </div>
            <button type="submit" style="padding: 8px 16px; background: var(--primary-color); color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: 600;">
                🔍 Filter
            </button>
        </form>
    </div>

    @if(session('success'))
        <div style="padding: 16px; background: #dcfce7; border: 1px solid #86efac; border-radius: 8px; color: #166534; margin-bottom: 16px;">
            ✅ {{ session('success') }}
        </div>
    @endif

    <div class="dashboard-grid" style="grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));">
        @forelse($blogs as $blog)
            <div class="card" style="position: relative;">
                @if($blog->featured_image)
                    <img src="{{ asset('storage/' . $blog->featured_image) }}" alt="{{ $blog->title }}" style="width: 100%; height: 180px; object-fit: cover; border-radius: 8px; margin-bottom: 12px;">
                @else
                    <div style="width: 100%; height: 180px; background: linear-gradient(135deg, {{ $blog->category->color ?? '#3b82f6' }}, #22d3ee); border-radius: 8px; margin-bottom: 12px; display: flex; align-items: center; justify-content: center; font-size: 48px;">
                        {{ $blog->category->icon ?? '📝' }}
                    </div>
                @endif
                
                <div style="position: absolute; top: 12px; right: 12px;">
                    @if($blog->is_published)
                        <span class="status-badge status-active">Published</span>
                    @else
                        <span class="status-badge status-pending">Draft</span>
                    @endif
                </div>

                <div style="margin-bottom: 12px;">
                    @if($blog->category)
                        <span style="display: inline-block; padding: 4px 8px; background: {{ $blog->category->color }}; color: white; border-radius: 4px; font-size: 11px; font-weight: 600; margin-bottom: 8px;">
                            {{ $blog->category->icon }} {{ $blog->category->name }}
                        </span>
                    @endif
                    <h3 style="margin: 0 0 8px 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary); line-height: 1.4;">
                        {{ Str::limit($blog->title, 60) }}
                    </h3>
                    <p style="margin: 0; color: var(--text-secondary); font-size: 14px; line-height: 1.5;">
                        {{ Str::limit($blog->excerpt, 100) }}
                    </p>
                </div>

                <div style="display: flex; justify-content: space-between; align-items: center; padding-top: 12px; border-top: 1px solid var(--border-color); font-size: 13px; color: var(--text-secondary);">
                    <div>
                        <span>👁️ {{ $blog->views_count }}</span>
                        <span style="margin-left: 12px;">📅 {{ $blog->created_at->format('M d') }}</span>
                    </div>
                    <div style="display: flex; gap: 8px;">
                        <a href="{{ route('admin.blogs.edit', $blog) }}" style="padding: 4px 8px; background: var(--primary-color); color: white; border-radius: 4px; text-decoration: none; font-size: 12px; font-weight: 600;">
                            ✏️ Edit
                        </a>
                    </div>
                </div>
            </div>
        @empty
            <div class="card" style="grid-column: 1 / -1; text-align: center; padding: 60px 20px; color: var(--text-secondary);">
                <div style="font-size: 48px; margin-bottom: 16px;">📝</div>
                <h3 style="margin: 0 0 8px 0; color: var(--text-primary);">No Blog Posts Yet</h3>
                <p style="margin: 0 0 20px 0;">Create your first blog post to get started.</p>
                <a href="{{ route('admin.blogs.create') }}" style="padding: 10px 20px; background: var(--success-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; gap: 8px;">
                    <span>➕</span> Create Blog Post
                </a>
            </div>
        @endforelse
    </div>

    @if($blogs->hasPages())
        <div style="margin-top: 24px; display: flex; justify-content: center;">
            {{ $blogs->links() }}
        </div>
    @endif
</div>
@endsection
