@extends('admin.layouts.app')

@section('title', 'Create Blog Post')

@section('content')
<div style="max-width: 1200px;">
    <div style="margin-bottom: 24px;">
        <h2 style="margin: 0 0 4px 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Create Blog Post</h2>
        <p style="margin: 0; color: var(--text-secondary); font-size: 14px;">Write and publish a new blog post</p>
    </div>

    <form action="{{ route('admin.blogs.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        
        <div style="display: grid; grid-template-columns: 1fr 350px; gap: 24px;">
            {{-- Main Content --}}
            <div style="display: flex; flex-direction: column; gap: 20px;">
                {{-- Title --}}
                <div class="card">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Title *</label>
                    <input type="text" name="title" required value="{{ old('title') }}" placeholder="Enter blog title..." style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-size: 16px; background: var(--card-bg); color: var(--text-primary);">
                    @error('title')
                        <span style="color: var(--danger-color); font-size: 13px; margin-top: 4px; display: block;">{{ $message }}</span>
                    @enderror
                </div>

                {{-- Slug --}}
                <div class="card">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Slug (optional - auto-generated)</label>
                    <input type="text" name="slug" value="{{ old('slug') }}" placeholder="blog-post-slug" style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-size: 14px; background: var(--card-bg); color: var(--text-primary);">
                </div>

                {{-- Excerpt --}}
                <div class="card">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Excerpt (optional)</label>
                    <textarea name="excerpt" rows="3" placeholder="Brief summary..." style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-size: 14px; background: var(--card-bg); color: var(--text-primary); resize: vertical;">{{ old('excerpt') }}</textarea>
                </div>

                {{-- Rich Text Content --}}
                <div class="card">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Content *</label>
                    <textarea id="blog-content" name="content" style="width: 100%; min-height: 400px;">{{ old('content') }}</textarea>
                    @error('content')
                        <span style="color: var(--danger-color); font-size: 13px; margin-top: 4px; display: block;">{{ $message }}</span>
                    @enderror
                </div>

                {{-- SEO Section --}}
                <div class="card">
                    <h3 style="margin: 0 0 16px 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary);">🔍 SEO Settings</h3>
                    
                    <div style="margin-bottom: 16px;">
                        <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary); font-size: 14px;">Meta Title</label>
                        <input type="text" name="meta_title" value="{{ old('meta_title') }}" placeholder="SEO title" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
                    </div>
                    
                    <div style="margin-bottom: 16px;">
                        <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary); font-size: 14px;">Meta Description</label>
                        <textarea name="meta_description" rows="2" placeholder="SEO description" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">{{ old('meta_description') }}</textarea>
                    </div>
                    
                    <div>
                        <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary); font-size: 14px;">Meta Keywords</label>
                        <input type="text" name="meta_keywords" value="{{ old('meta_keywords') }}" placeholder="keyword1, keyword2, keyword3" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
                        <small style="color: var(--text-secondary); font-size: 12px; margin-top: 4px; display: block;">Separate keywords with commas</small>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div style="display: flex; flex-direction: column; gap: 20px;">
                {{-- Publish --}}
                <div class="card">
                    <h3 style="margin: 0 0 16px 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary);">📤 Publish</h3>
                    
                    <label style="display: flex; align-items: center; gap: 12px; cursor: pointer; padding: 12px; background: var(--bg-color); border-radius: 8px; margin-bottom: 16px;">
                        <input type="checkbox" name="is_published" value="1" {{ old('is_published') ? 'checked' : '' }} style="width: 18px; height: 18px;">
                        <span style="font-weight: 600; font-size: 14px;">Publish immediately</span>
                    </label>

                    <button type="submit" style="width: 100%; padding: 12px; background: var(--success-color); color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; font-size: 15px;">
                        💾 Save Blog Post
                    </button>
                </div>

                {{-- Featured Image --}}
                <div class="card">
                    <h3 style="margin: 0 0 12px 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary);">🖼️ Featured Image</h3>
                    <input type="file" name="featured_image" accept="image/*" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
                    <small style="color: var(--text-secondary); font-size: 12px; margin-top: 4px; display: block;">Max 2MB - JPG, PNG, GIF</small>
                </div>

                {{-- Category --}}
                <div class="card">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">🏷️ Category</label>
                    <select name="blog_category_id" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
                        <option value="">Select category...</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('blog_category_id') == $category->id ? 'selected' : '' }}>
                                {{ $category->icon }} {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- Associations --}}
                <div class="card">
                    <h3 style="margin: 0 0 12px 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary);">🔗 Associations</h3>
                    
                    <div style="margin-bottom: 12px;">
                        <label style="display: block; margin-bottom: 6px; font-weight: 600; color: var(--text-secondary); font-size: 13px;">Premium Plan</label>
                        <select name="user_plan_id" style="width: 100%; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary); font-size: 14px;">
                            <option value="">None</option>
                            @foreach($plans as $plan)
                                <option value="{{ $plan->id }}">{{ $plan->plan_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div>
                        <label style="display: block; margin-bottom: 6px; font-weight: 600; color: var(--text-secondary); font-size: 13px;">Package</label>
                        <select name="package_id" style="width: 100%; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary); font-size: 14px;">
                            <option value="">None</option>
                            @foreach($packages as $package)
                                <option value="{{ $package->id }}">{{ $package->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                {{-- Ad Units --}}
                <div class="card">
                    <h3 style="margin: 0 0 12px 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary);">💰 Ad Units</h3>
                    
                    <div style="margin-bottom: 12px;">
                        <label style="display: block; margin-bottom: 6px; font-weight: 600; color: var(--text-secondary); font-size: 13px;">Top Banner @if($defaultBanner)<span style="color: var(--success-color); font-size: 11px;">(Default: {{ $defaultBanner->name }})</span>@endif</label>
                        <select name="ad_unit_top_banner_id" style="width: 100%; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary); font-size: 14px;">
                            <option value="">Use Default{{ $defaultBanner ? ' - ' . $defaultBanner->name : '' }}</option>
                            @if(isset($adUnits['banner']))
                                @foreach($adUnits['banner'] as $unit)
                                    <option value="{{ $unit->id }}">{{ $unit->name }} ({{ $unit->network }})</option>
                                @endforeach
                            @endif
                        </select>
                        <small style="color: var(--text-secondary); font-size: 11px; display: block; margin-top: 2px;">320x50 or 728x90 - Leave blank for default</small>
                    </div>
                    
                    <div style="margin-bottom: 12px;">
                        <label style="display: block; margin-bottom: 6px; font-weight: 600; color: var(--text-secondary); font-size: 13px;">In-Content Native @if($defaultNative)<span style="color: var(--success-color); font-size: 11px;">(Default: {{ $defaultNative->name }})</span>@endif</label>
                        <select name="ad_unit_in_content_native_id" style="width: 100%; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary); font-size: 14px;">
                            <option value="">Use Default{{ $defaultNative ? ' - ' . $defaultNative->name : '' }}</option>
                            @if(isset($adUnits['native']))
                                @foreach($adUnits['native'] as $unit)
                                    <option value="{{ $unit->id }}">{{ $unit->name }} ({{ $unit->network }})</option>
                                @endforeach
                            @endif
                        </select>
                        <small style="color: var(--text-secondary); font-size: 11px; display: block; margin-top: 2px;">Native ad format - Leave blank for default</small>
                    </div>
                    
                    <div>
                        <label style="display: block; margin-bottom: 6px; font-weight: 600; color: var(--text-secondary); font-size: 13px;">Bottom Interstitial @if($defaultInterstitial)<span style="color: var(--success-color); font-size: 11px;">(Default: {{ $defaultInterstitial->name }})</span>@endif</label>
                        <select name="ad_unit_bottom_interstitial_id" style="width: 100%; padding: 8px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary); font-size: 14px;">
                            <option value="">Use Default{{ $defaultInterstitial ? ' - ' . $defaultInterstitial->name : '' }}</option>
                            @if(isset($adUnits['interstitial']))
                                @foreach($adUnits['interstitial'] as $unit)
                                    <option value="{{ $unit->id }}">{{ $unit->name }} ({{ $unit->network }})</option>
                                @endforeach
                            @endif
                        </select>
                        <small style="color: var(--text-secondary); font-size: 11px; display: block; margin-top: 2px;">Full-screen ad - Leave blank for default</small>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

{{-- TinyMCE Integration --}}
<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
    tinymce.init({
        selector: '#blog-content',
        height: 500,
        menubar: true,
        plugins: [
            'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
            'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
            'insertdatetime', 'media', 'table', 'help', 'wordcount'
        ],
        toolbar: 'undo redo | blocks | bold italic underline strikethrough | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media | removeformat code | help',
        content_style: 'body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; font-size: 16px; line-height: 1.6; }',
        images_upload_url: '{{ route('admin.blogs.uploadImage') }}',
        automatic_uploads: true,
        images_upload_handler: function (blobInfo, success, failure) {
            var xhr, formData;
            xhr = new XMLHttpRequest();
            xhr.withCredentials = false;
            xhr.open('POST', '{{ route('admin.blogs.uploadImage') }}');
            xhr.setRequestHeader('X-CSRF-TOKEN', '{{ csrf_token() }}');
            
            xhr.onload = function() {
                var json;
                if (xhr.status != 200) {
                    failure('HTTP Error: ' + xhr.status);
                    return;
                }
                json = JSON.parse(xhr.responseText);
                if (!json || typeof json.location != 'string') {
                    failure('Invalid JSON: ' + xhr.responseText);
                    return;
                }
                success(json.location);
            };
            
            formData = new FormData();
            formData.append('file', blobInfo.blob(), blobInfo.filename());
            xhr.send(formData);
        }
    });
</script>
@endsection
