@extends('admin.layouts.app')

@section('title', 'Blog Categories')

@section('content')
<div class="dashboard-grid" style="grid-template-columns: 1fr; gap: 24px;">
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px;">
        <div>
            <h2 style="margin: 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Blog Categories</h2>
            <p style="margin: 4px 0 0 0; color: var(--text-secondary); font-size: 14px;">Manage blog categories</p>
        </div>
        <a href="{{ route('admin.blog-categories.create') }}" style="padding: 10px 20px; background: var(--success-color); color: white; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; text-decoration: none; display: flex; align-items: center; gap: 8px;">
            <span>➕</span> Add Category
        </a>
    </div>

    @if(session('success'))
        <div style="padding: 16px; background: #dcfce7; border: 1px solid #86efac; border-radius: 8px; color: #166534; margin-bottom: 16px;">
            ✅ {{ session('success') }}
        </div>
    @endif

    <div class="card">
        @if($categories->count() > 0)
            <table class="table">
                <thead>
                    <tr>
                        <th style="width: 5%;">Order</th>
                        <th style="width: 25%;">Name</th>
                        <th style="width: 25%;">Slug</th>
                        <th style="width: 15%;">Posts</th>
                        <th style="width: 10%;">Status</th>
                        <th style="width: 20%; text-align: center;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categories as $category)
                        <tr>
                            <td style="font-weight: 600; color: var(--text-secondary);">{{ $category->order }}</td>
                            <td style="font-weight: 600;">
                                @if($category->icon)
                                    <span style="margin-right: 6px;">{{ $category->icon }}</span>
                                @endif
                                <span style="display: inline-block; width: 12px; height: 12px; border-radius: 50%; background: {{ $category->color }}; margin-right: 8px;"></span>
                                {{ $category->name }}
                            </td>
                            <td>
                                <code style="background: var(--bg-color); padding: 4px 8px; border-radius: 4px; font-size: 12px;">{{ $category->slug }}</code>
                            </td>
                            <td>
                                <span style="font-weight: 600;">{{ $category->blogs_count }}</span> posts
                            </td>
                            <td>
                                @if($category->is_active)
                                    <span class="status-badge status-active">Active</span>
                                @else
                                    <span class="status-badge status-inactive">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <div style="display: flex; gap: 8px; justify-content: center;">
                                    <a href="{{ route('admin.blog-categories.edit', $category) }}" style="padding: 6px 12px; background: var(--primary-color); color: white; border-radius: 6px; text-decoration: none; font-size: 13px; font-weight: 600;">
                                        ✏️ Edit
                                    </a>
                                    <form action="{{ route('admin.blog-categories.destroy', $category) }}" method="POST" onsubmit="return confirm('Delete this category?');" style="display: inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" style="padding: 6px 12px; background: var(--danger-color); color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 13px; font-weight: 600;">
                                            🗑️ Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <div style="text-align: center; padding: 60px 20px; color: var(--text-secondary);">
                <div style="font-size: 48px; margin-bottom: 16px;">🏷️</div>
                <h3 style="margin: 0 0 8px 0; color: var(--text-primary);">No Categories Yet</h3>
                <p style="margin: 0 0 20px 0;">Create your first blog category.</p>
            </div>
        @endif
    </div>
</div>
@endsection
