@extends('admin.layouts.app')

@section('title', 'Create Blog Category')

@section('content')
<div style="max-width: 800px;">
    <h2 style="margin: 0 0 24px 0; font-size: 1.5rem; font-weight: 600; color: var(--text-primary);">Create Blog Category</h2>

    <form action="{{ route('admin.blog-categories.store') }}" method="POST">
        @csrf
        
        <div class="card" style="margin-bottom: 20px;">
            <h3 style="margin: 0 0 16px 0; font-size: 1.125rem; font-weight: 600; color: var(--text-primary);">Category Details</h3>
            
            <div style="margin-bottom: 16px;">
                <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Name *</label>
                <input type="text" name="name" required value="{{ old('name') }}" placeholder="e.g., Tips & Tricks" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
            </div>
            
            <div style="margin-bottom: 16px;">
                <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Slug (optional)</label>
                <input type="text" name="slug" value="{{ old('slug') }}" placeholder="tips-tricks" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
                <small style="color: var(--text-secondary); font-size: 12px;">Leave blank to auto-generate</small>
            </div>
            
            <div style="margin-bottom: 16px;">
                <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Description</label>
                <textarea name="description" rows="3" placeholder="Brief description..." style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">{{ old('description') }}</textarea>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 16px; margin-bottom: 16px;">
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Icon (Emoji)</label>
                    <input type="text" name="icon" value="{{ old('icon', '📝') }}" placeholder="📝" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary); font-size: 24px; text-align: center;">
                </div>
                
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Color</label>
                    <input type="color" name="color" value="{{ old('color', '#3b82f6') }}" style="width: 100%; height: 44px; border: 1px solid var(--border-color); border-radius: 6px; cursor: pointer;">
                </div>
                
                <div>
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: var(--text-primary);">Order</label>
                    <input type="number" name="order" value="{{ old('order', 0) }}" min="0" style="width: 100%; padding: 10px; border: 1px solid var(--border-color); border-radius: 6px; background: var(--card-bg); color: var(--text-primary);">
                </div>
            </div>
            
            <label style="display: flex; align-items: center; gap: 12px; cursor: pointer; padding: 12px; background: var(--bg-color); border-radius: 8px;">
                <input type="checkbox" name="is_active" value="1" checked style="width: 18px; height: 18px;">
                <span style="font-weight: 600; font-size: 14px;">Active</span>
            </label>
        </div>
        
        <div style="display: flex; gap: 12px;">
            <button type="submit" style="flex: 1; padding: 12px; background: var(--success-color); color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer;">
                💾 Create Category
            </button>
            <a href="{{ route('admin.blog-categories.index') }}" style="padding: 12px 24px; background: var(--border-color); color: var(--text-primary); border: none; border-radius: 8px; font-weight: 600; text-decoration: none; display: flex; align-items: center; justify-content: center;">
                Cancel
            </a>
        </div>
    </form>
</div>
@endsection
