@extends('admin.layouts.app')

@section('title', 'Banner Packages')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-7xl">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center justify-between mb-10 gap-6">
        <div>
             <h1 class="text-3xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-gray-900 to-gray-600 tracking-tight">Pricing Packages</h1>
            <p class="text-sm text-gray-500 font-medium mt-1">Configure your competitive banner advertising tiers.</p>
        </div>
        <div>
            <a href="{{ route('admin.banners.packages.create') }}" class="inline-flex items-center px-6 py-3 rounded-xl bg-gradient-to-r from-blue-600 to-indigo-600 text-white font-bold shadow-lg shadow-blue-200 hover:shadow-xl hover:-translate-y-1 transition-all duration-300">
                <i class="fas fa-plus mr-2"></i> Create New Package
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-50 border-l-4 border-green-500 p-4 mb-8 rounded-r-xl shadow-sm flex items-center justify-between animate-fade-in-down">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <i class="fas fa-check-circle text-green-500 text-xl"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-bold text-green-800">{{ session('success') }}</p>
                </div>
            </div>
            <button type="button" class="text-green-500 hover:text-green-700" onclick="this.parentElement.remove()">
                <i class="fas fa-times"></i>
            </button>
        </div>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-8">
        @forelse($packages as $package)
            <div class="relative flex flex-col h-full bg-white rounded-3xl shadow-xl shadow-gray-100/50 border border-gray-100 overflow-hidden transform hover:-translate-y-2 transition-transform duration-300 group">
                
                @if($loop->iteration == 2) 
                    <div class="absolute top-0 right-0">
                        <div class="bg-gradient-to-r from-indigo-500 to-purple-600 text-white text-[10px] font-bold uppercase tracking-widest py-1 px-8 transform rotate-45 translate-x-8 translate-y-4 shadow-sm">
                            Most Popular
                        </div>
                    </div>
                @endif
                
                <!-- Package Header -->
                <div class="p-8 text-center border-b border-gray-50 relative overflow-hidden">
                    <div class="absolute inset-0 bg-gradient-to-b from-gray-50/50 to-transparent"></div>
                    <div class="relative z-10">
                        @if(!$package->is_active)
                            <span class="inline-block px-3 py-1 rounded-full bg-gray-100 text-gray-500 text-xs font-bold uppercase tracking-wide mb-4 border border-gray-200">
                                Inactive
                            </span>
                        @else
                            <span class="inline-block px-3 py-1 rounded-full bg-emerald-50 text-emerald-600 text-xs font-bold uppercase tracking-wide mb-4 border border-emerald-100">
                                Active Plan
                            </span>
                        @endif
                        
                        <h3 class="text-2xl font-extrabold text-gray-900 uppercase tracking-tight mb-2">{{ $package->name }}</h3>
                        <p class="text-sm text-gray-500 font-medium mb-6 px-4">{{ $package->description }}</p>
                        
                        <div class="flex items-baseline justify-center text-indigo-900">
                            <span class="text-3xl font-bold mr-1">₹</span>
                            <span class="text-5xl font-extrabold tracking-tight">{{ number_format($package->base_price_per_impression * 1000, 0) }}</span>
                            <span class="text-gray-400 font-medium ml-2">/ 1k views</span>
                        </div>
                    </div>
                </div>

                <!-- Features -->
                <div class="flex-1 p-8 bg-gray-50/30">
                    <ul class="space-y-4">
                        <li class="flex items-center">
                            <div class="w-6 h-6 rounded-full bg-green-100 text-green-600 flex items-center justify-center mr-3 flex-shrink-0">
                                <i class="fas fa-check text-xs"></i>
                            </div>
                            <span class="text-gray-700 font-medium">
                                <strong class="text-gray-900">{{ number_format($package->max_impressions_included) }}</strong> Impressions
                            </span>
                        </li>
                        <li class="flex items-center">
                            <div class="w-6 h-6 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center mr-3 flex-shrink-0">
                                <i class="fas fa-layer-group text-xs"></i>
                            </div>
                            <span class="text-gray-700 font-medium">
                                Priority Level: <strong class="text-gray-900">{{ ucfirst($package->features['priority_level'] ?? 'Standard') }}</strong>
                            </span>
                        </li>
                        
                        <li class="flex items-center">
                            <div class="w-6 h-6 rounded-full bg-indigo-100 text-indigo-600 flex items-center justify-center mr-3 flex-shrink-0">
                                <i class="fas fa-chart-pie text-xs"></i>
                            </div>
                            <span class="text-gray-700 font-medium">
                                Analytics: <strong class="text-gray-900">{{ ucfirst($package->features['analytics'] ?? 'Basic') }}</strong>
                            </span>
                        </li>

                        <li class="flex items-center">
                            <div class="w-6 h-6 rounded-full bg-amber-100 text-amber-600 flex items-center justify-center mr-3 flex-shrink-0">
                                <i class="fas fa-tag text-xs"></i>
                            </div>
                            <span class="text-gray-700 font-medium">
                                Discount: <strong class="text-gray-900">{{ $package->discount_percentage }}% Off</strong>
                            </span>
                        </li>
                        
                        <li class="flex items-center">
                            <div class="w-6 h-6 rounded-full bg-purple-100 text-purple-600 flex items-center justify-center mr-3 flex-shrink-0">
                                <i class="fas fa-map-marker-alt text-xs"></i>
                            </div>
                            <span class="text-gray-700 font-medium">Location Targeting</span>
                        </li>
                    </ul>
                </div>

                <!-- Actions -->
                <div class="p-6 bg-white border-t border-gray-100">
                    <a href="{{ route('admin.banners.packages.edit', $package) }}" class="block w-full text-center py-3 rounded-xl border-2 border-indigo-100 text-indigo-600 font-bold hover:bg-indigo-50 hover:border-indigo-200 transition-colors mb-4">
                        Edit Details
                    </a>
                    
                    <div class="flex justify-between gap-3">
                         <form action="{{ route('admin.banners.packages.toggle', $package) }}" method="POST" class="flex-1">
                            @csrf
                            <button type="submit" class="w-full py-2.5 rounded-xl text-sm font-bold flex items-center justify-center gap-2 transition-colors {{ $package->is_active ? 'bg-amber-50 text-amber-600 hover:bg-amber-100' : 'bg-emerald-50 text-emerald-600 hover:bg-emerald-100' }}">
                                <i class="fas fa-power-off"></i> {{ $package->is_active ? 'Deactivate' : 'Activate' }}
                            </button>
                        </form>
                        
                        <form action="{{ route('admin.banners.packages.destroy', $package) }}" method="POST" class="flex-none" onsubmit="return confirm('Delete this package?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="w-10 h-10 rounded-xl bg-red-50 text-red-500 hover:bg-red-100 flex items-center justify-center transition-colors" title="Delete">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-span-full text-center py-20">
                <div class="w-24 h-24 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-6 shadow-sm">
                    <i class="fas fa-box-open text-gray-300 text-4xl"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-2">No Packages Found</h3>
                <p class="text-gray-500 mb-8">Set up your pricing tiers to start earning revenue.</p>
                <a href="{{ route('admin.banners.packages.create') }}" class="inline-flex items-center px-8 py-3 rounded-full bg-blue-600 text-white font-bold hover:bg-blue-700 transition-colors shadow-lg shadow-blue-200">
                    <i class="fas fa-plus mr-2"></i> Create First Package
                </a>
            </div>
        @endforelse
    </div>
</div>

<style>
@keyframes fadeInDown {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}
.animate-fade-in-down {
    animation: fadeInDown 0.3s ease-out forwards;
}
</style>
@endsection
