@extends('admin.layouts.app')

@section('title', 'Create Banner Package')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Create Package</h1>
        <a href="{{ route('admin.banners.packages.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to Packages
        </a>
    </div>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-body">
            <form action="{{ route('admin.banners.packages.store') }}" method="POST">
                @csrf
                
                <div class="row">
                    <div class="col-md-6 border-right">
                        <h5 class="mb-4">Package Details</h5>
                        
                        <div class="form-group">
                            <label>Package Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                        </div>

                        <div class="form-group">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="3">{{ old('description') }}</textarea>
                        </div>

                        <div class="form-group">
                            <label>Promotional Text</label>
                            <input type="text" name="promotional_text" class="form-control" value="{{ old('promotional_text') }}">
                        </div>

                        <div class="form-group">
                            <label>Display Order</label>
                            <input type="number" name="display_order" class="form-control" value="{{ old('display_order', 0) }}">
                        </div>
                        
                        <div class="custom-control custom-switch mt-4">
                            <input type="checkbox" class="custom-control-input" id="isActive" name="is_active" value="1" {{ old('is_active', 1) ? 'checked' : '' }}>
                            <label class="custom-control-label" for="isActive">Active Status</label>
                        </div>
                    </div>
                    
                    <div class="col-md-6 pl-md-4">
                        <h5 class="mb-4">Pricing & Limits</h5>
                        
                        <div class="form-group">
                            <label>Price per 1k Impressions (₹) <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" name="cpm_price" class="form-control" 
                                   onchange="document.getElementById('base_price').value = this.value / 1000" required>
                            <input type="hidden" id="base_price" name="base_price_per_impression" value="{{ old('base_price_per_impression') }}">
                            <small class="text-muted">Base unit price will be calculated automatically</small>
                        </div>

                        <div class="form-group">
                            <label>Included Impressions</label>
                            <input type="number" name="max_impressions_included" class="form-control" value="{{ old('max_impressions_included', 10000) }}">
                        </div>

                        <div class="form-group">
                            <label>Discount Percentage (%)</label>
                            <input type="number" step="0.1" name="discount_percentage" class="form-control" value="{{ old('discount_percentage', 0) }}">
                        </div>

                        <h5 class="mt-4 mb-3">Features (JSON)</h5>
                        
                        <div class="form-group">
                            <label>Priority Level</label>
                            <select name="features[priority_level]" class="form-control">
                                <option value="Standard">Standard</option>
                                <option value="High">High</option>
                                <option value="Urgent">Urgent</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label>Analytics Level</label>
                            <select name="features[analytics]" class="form-control">
                                <option value="Basic">Basic</option>
                                <option value="Advanced">Advanced (Demographics)</option>
                                <option value="Real-time">Real-time + Heatmaps</option>
                            </select>
                        </div>
                    </div>
                </div>

                <hr class="my-4">
                
                <div class="text-right">
                    <button type="submit" class="btn btn-primary btn-lg px-5">Create Package</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
