@extends('admin.layouts.app')

@section('title', 'Create Banner')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-7xl">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center justify-between mb-8 gap-4">
        <div class="flex items-center gap-4">
            <a href="{{ route('admin.banners.index') }}" class="w-12 h-12 rounded-full bg-white shadow-sm flex items-center justify-center text-gray-500 hover:text-indigo-600 hover:shadow-md transition-all group border border-gray-100">
                <i class="fas fa-arrow-left group-hover:-translate-x-1 transition-transform"></i>
            </a>
            <div>
                <h1 class="text-3xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-gray-900 to-gray-600 tracking-tight">Create Campaign</h1>
                <p class="text-sm text-gray-500 font-medium mt-1">Design high-converting banners with precise targeting.</p>
            </div>
        </div>
        <div class="flex gap-3">
             <button type="button" class="px-5 py-2.5 rounded-xl bg-white text-gray-600 font-bold border border-gray-200 hover:bg-gray-50 transition-all shadow-sm">
                <i class="far fa-eye mr-2"></i> Preview
            </button>
        </div>
    </div>

    @if($errors->any())
        <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-8 rounded-r-xl shadow-sm animate-fade-in-down">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-exclamation-circle text-red-500 text-xl"></i>
                </div>
                <div class="ml-4">
                    <h3 class="text-sm font-bold text-red-800">Please correct the following errors:</h3>
                    <ul class="mt-2 text-sm text-red-700 list-disc list-inside space-y-1">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.banners.store') }}" method="POST" enctype="multipart/form-data" id="createBannerForm">
        @csrf
        <div class="grid grid-cols-1 xl:grid-cols-3 gap-8">
            
            <!-- Left Column: Creative & Targeting (Span 2) -->
            <div class="xl:col-span-2 space-y-8">
                
                <!-- Creative Assets Card -->
                <div class="bg-white rounded-3xl shadow-xl shadow-gray-100/50 overflow-hidden border border-gray-100">
                    <div class="px-8 py-6 border-b border-gray-50 bg-gradient-to-r from-gray-50 to-white flex items-center gap-4">
                        <div class="w-10 h-10 rounded-2xl bg-gradient-to-br from-indigo-500 to-violet-600 text-white flex items-center justify-center shadow-lg shadow-indigo-200">
                            <i class="fas fa-paint-brush"></i>
                        </div>
                        <div>
                            <h2 class="text-xl font-bold text-gray-900">Creative Assets</h2>
                            <p class="text-xs text-gray-500 font-medium">Define how your campaign looks</p>
                        </div>
                    </div>
                    
                    <div class="p-8 space-y-8">
                        <!-- Title Input -->
                        <div class="group">
                            <label class="block text-xs font-extrabold uppercase text-gray-400 tracking-wider mb-3 group-hover:text-indigo-600 transition-colors">Campaign Title</label>
                            <div class="relative">
                                <span class="absolute left-5 top-1/2 -translate-y-1/2 text-gray-300 group-hover:text-indigo-400 transition-colors text-lg">
                                    <i class="fas fa-heading"></i>
                                </span>
                                <input type="text" 
                                       name="title" 
                                       class="w-full pl-14 pr-5 py-4 rounded-2xl border-2 border-gray-100 bg-gray-50/50 text-gray-900 font-bold text-lg focus:bg-white focus:border-indigo-500 focus:ring-4 focus:ring-indigo-500/10 transition-all placeholder-gray-400 outline-none"
                                       placeholder="e.g. Summer Super Sale 2026" 
                                       required>
                            </div>
                        </div>

                        <!-- Image Upload -->
                        <div>
                            <label class="block text-xs font-extrabold uppercase text-gray-400 tracking-wider mb-3">Banner Image</label>
                            <div class="relative group">
                                <div id="drop-zone" class="border-3 border-dashed border-gray-200 rounded-3xl p-10 text-center bg-gray-50/50 hover:bg-indigo-50/30 hover:border-indigo-400 transition-all cursor-pointer relative overflow-hidden group-hover:shadow-inner">
                                    
                                    <!-- Placeholder State -->
                                    <div id="upload-placeholder" class="space-y-4 transition-all duration-300">
                                        <div class="w-20 h-20 rounded-full bg-white shadow-md mx-auto flex items-center justify-center text-indigo-500 group-hover:scale-110 group-hover:text-indigo-600 transition-all duration-300 border border-gray-100">
                                            <i class="fas fa-cloud-upload-alt text-3xl"></i>
                                        </div>
                                        <div>
                                            <div class="text-lg font-bold text-gray-700">
                                                Click to upload or drag & drop
                                            </div>
                                            <p class="text-sm text-gray-400 mt-1">SVG, PNG, JPG or GIF (Rec. 800x200px)</p>
                                        </div>
                                    </div>

                                    <!-- Preview State -->
                                    <div id="imagePreview" style="display: none;" class="relative w-full">
                                        <img id="preview" src="" class="w-full h-auto max-h-[300px] object-cover rounded-2xl shadow-lg ring-1 ring-black/5">
                                        <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center rounded-2xl backdrop-blur-sm">
                                            <button type="button" onclick="removeImage()" class="bg-white text-red-500 px-6 py-3 rounded-xl text-sm font-bold hover:bg-red-50 transition-all shadow-xl transform hover:scale-105 flex items-center gap-2">
                                                <i class="fas fa-trash-alt"></i> Remove Image
                                            </button>
                                        </div>
                                    </div>

                                    <input type="file" name="image" id="image" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer" accept="image/*" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Targeting & Actions Card -->
                <div class="bg-white rounded-3xl shadow-xl shadow-gray-100/50 overflow-hidden border border-gray-100">
                    <div class="px-8 py-6 border-b border-gray-50 bg-gradient-to-r from-gray-50 to-white flex items-center gap-4">
                        <div class="w-10 h-10 rounded-2xl bg-gradient-to-br from-emerald-400 to-teal-500 text-white flex items-center justify-center shadow-lg shadow-emerald-200">
                            <i class="fas fa-bullseye"></i>
                        </div>
                        <div>
                            <h2 class="text-xl font-bold text-gray-900">Targeting & Actions</h2>
                            <p class="text-xs text-gray-500 font-medium">Where users go when they click</p>
                        </div>
                    </div>

                    <div class="p-8">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                            <!-- Click Destination -->
                            <div class="group">
                                <label class="block text-xs font-extrabold uppercase text-gray-400 tracking-wider mb-3 group-hover:text-emerald-600 transition-colors">Click Action</label>
                                <div class="relative">
                                    <span class="absolute left-5 top-1/2 -translate-y-1/2 text-emerald-500 text-lg z-10 pointer-events-none">
                                        <i class="fas fa-mouse-pointer"></i>
                                    </span>
                                    <select name="redirect_type" id="redirect_type" class="appearance-none w-full pl-14 pr-10 py-4 rounded-2xl border-2 border-gray-100 bg-white text-gray-900 font-bold focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 transition-all cursor-pointer outline-none shadow-sm hover:border-gray-300">
                                        <option value="static">🔒 No Action (Display Only)</option>
                                        <option value="url">🌐 External Website</option>
                                        <option value="category">📂 Category Page</option>
                                        <option value="package">📦 Subscriptions Page</option>
                                        <option value="user_profile">👤 User Profile</option>
                                    </select>
                                    <div class="absolute right-5 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none">
                                        <i class="fas fa-chevron-down"></i>
                                    </div>
                                </div>
                            </div>

                            <!-- Geographic Reach -->
                            <div class="group">
                                <label class="block text-xs font-extrabold uppercase text-gray-400 tracking-wider mb-3 group-hover:text-blue-600 transition-colors">Target Location</label>
                                <div class="relative">
                                     <span class="absolute left-5 top-1/2 -translate-y-1/2 text-blue-500 text-lg z-10 pointer-events-none">
                                        <i class="fas fa-globe-americas"></i>
                                    </span>
                                    <select name="target_location_type" id="target_location_type" class="appearance-none w-full pl-14 pr-10 py-4 rounded-2xl border-2 border-gray-100 bg-white text-gray-900 font-bold focus:border-blue-500 focus:ring-4 focus:ring-blue-500/10 transition-all cursor-pointer outline-none shadow-sm hover:border-gray-300">
                                        <option value="all">🌍 Global (Everywhere)</option>
                                        <option value="country">🏳️ Specific Countries</option>
                                        <option value="city">🏙️ Specific Cities</option>
                                    </select>
                                    <div class="absolute right-5 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none">
                                        <i class="fas fa-chevron-down"></i>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Dynamic Options Panel -->
                        <div id="dynamic_options" style="display: none;" class="bg-gray-50 rounded-2xl p-6 border-2 border-dashed border-gray-200 animate-fade-in-down">
                            <h4 class="text-xs font-bold uppercase text-gray-400 mb-4 flex items-center gap-2">
                                <span class="w-2 h-2 rounded-full bg-indigo-500"></span> Specific Details
                            </h4>
                            
                            <!-- Destination Value Input -->
                            <div id="redirect_value_group" class="mb-4" style="display: none;">
                                <label class="block text-sm font-bold text-gray-700 mb-2">Destination URL / ID</label>
                                <div class="relative">
                                    <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">
                                        <i class="fas fa-link"></i>
                                    </div>
                                    <input type="text" name="redirect_value" class="w-full pl-10 pr-4 py-3 rounded-xl border border-gray-200 bg-white focus:border-indigo-500 focus:ring-4 focus:ring-indigo-500/10 transition-all font-medium" placeholder="https://example.com or ID: 123">
                                </div>
                            </div>

                            <!-- Location Inputs -->
                            <div id="location_inputs" style="display: none;">
                                <div id="countries_group" class="mb-4">
                                    <label class="block text-sm font-bold text-gray-700 mb-2">Target Countries (Codes)</label>
                                    <input type="text" name="target_countries[]" class="w-full px-4 py-3 rounded-xl border border-gray-200 bg-white focus:border-indigo-500 focus:ring-4 focus:ring-indigo-500/10 transition-all font-medium" placeholder="IN, US, UK, CA (Comma separated)">
                                </div>
                                <div id="cities_group" style="display: none;">
                                    <label class="block text-sm font-bold text-gray-700 mb-2">Target Cities</label>
                                    <input type="text" name="target_cities[]" class="w-full px-4 py-3 rounded-xl border border-gray-200 bg-white focus:border-indigo-500 focus:ring-4 focus:ring-indigo-500/10 transition-all font-medium" placeholder="Mumbai, New York, London...">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: Settings & Publish (Span 1) -->
            <div class="space-y-8">
                
                <!-- Publishing Card -->
                <div class="bg-white rounded-3xl shadow-xl shadow-gray-100/50 overflow-hidden border border-gray-100 sticky top-24">
                    <div class="p-8">
                        <h3 class="text-xl font-bold text-gray-900 mb-6 flex items-center gap-2">
                            <i class="fas fa-rocket text-indigo-500"></i> Publishing
                        </h3>

                        <!-- Status Selection -->
                        <div class="mb-8">
                            <label class="block text-xs font-extrabold uppercase text-gray-400 tracking-wider mb-4">Status</label>
                            <div class="flex flex-col gap-3">
                                <label class="cursor-pointer relative group">
                                    <input type="radio" name="status" value="active" checked class="peer sr-only">
                                    <div class="p-4 rounded-2xl border-2 border-gray-100 bg-white hover:border-green-300 hover:bg-green-50/50 peer-checked:border-green-500 peer-checked:bg-green-50 transition-all flex items-center shadow-sm">
                                        <div class="w-12 h-12 rounded-xl bg-green-100 text-green-600 flex items-center justify-center mr-4 group-hover:scale-110 transition-transform">
                                            <i class="fas fa-check text-xl"></i>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-900">Active Now</div>
                                            <div class="text-xs text-green-600 font-bold">Live immediately</div>
                                        </div>
                                        <div class="ml-auto opacity-0 peer-checked:opacity-100 text-green-600">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                </label>

                                <label class="cursor-pointer relative group">
                                    <input type="radio" name="status" value="paused" class="peer sr-only">
                                    <div class="p-4 rounded-2xl border-2 border-gray-100 bg-white hover:border-amber-300 hover:bg-amber-50/50 peer-checked:border-amber-500 peer-checked:bg-amber-50 transition-all flex items-center shadow-sm">
                                        <div class="w-12 h-12 rounded-xl bg-amber-100 text-amber-600 flex items-center justify-center mr-4 group-hover:scale-110 transition-transform">
                                            <i class="fas fa-pause text-xl"></i>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-900">Paused</div>
                                            <div class="text-xs text-amber-600 font-bold">Save silently</div>
                                        </div>
                                         <div class="ml-auto opacity-0 peer-checked:opacity-100 text-amber-600">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                </label>

                                <label class="cursor-pointer relative group">
                                    <input type="radio" name="status" value="draft" class="peer sr-only">
                                    <div class="p-4 rounded-2xl border-2 border-gray-100 bg-white hover:border-gray-300 hover:bg-gray-50 peer-checked:border-gray-500 peer-checked:bg-gray-100 transition-all flex items-center shadow-sm">
                                        <div class="w-12 h-12 rounded-xl bg-gray-200 text-gray-500 flex items-center justify-center mr-4 group-hover:scale-110 transition-transform">
                                            <i class="fas fa-pencil-alt text-xl"></i>
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-900">Draft</div>
                                            <div class="text-xs text-gray-500 font-bold">Work in progress</div>
                                        </div>
                                         <div class="ml-auto opacity-0 peer-checked:opacity-100 text-gray-600">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <!-- Priority Slider -->
                        <div class="mb-8 p-4 bg-gray-50 rounded-2xl border border-gray-100">
                            <div class="flex justify-between items-center mb-4">
                                <label class="text-xs font-bold uppercase text-gray-500 tracking-wider">Display Priority</label>
                                <span class="bg-white text-indigo-600 shadow-sm border border-indigo-100 text-sm font-extrabold px-3 py-1 rounded-lg" id="priorityDisplay">0</span>
                            </div>
                            <input type="range" name="priority" id="priorityRange" min="0" max="100" value="0" 
                                   class="w-full h-2 bg-gray-200 rounded-lg appearance-none cursor-pointer accent-indigo-600 hover:accent-indigo-500 transition-all">
                            <div class="flex justify-between mt-2 px-1">
                                <span class="text-[10px] text-gray-400 font-bold uppercase">Low</span>
                                <span class="text-[10px] text-gray-400 font-bold uppercase">High</span>
                            </div>
                        </div>

                        <!-- Submit Button -->
                         <button type="submit" class="w-full py-4 rounded-2xl bg-gradient-to-r from-blue-600 via-indigo-600 to-indigo-700 text-white font-extrabold text-lg shadow-xl shadow-indigo-200 hover:shadow-2xl hover:-translate-y-1 hover:brightness-110 transition-all duration-300 transform group relative overflow-hidden">
                            <span class="relative z-10 flex items-center justify-center gap-3">
                                <i class="fas fa-rocket text-xl group-hover:animate-bounce"></i> 
                                Launch Campaign
                            </span>
                            <div class="absolute inset-0 bg-white/20 translate-y-full group-hover:translate-y-0 transition-transform duration-300 rounded-2xl"></div>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
// Image Preview Logic
const fileInput = document.getElementById('image');
const dropZone = document.getElementById('drop-zone');
const preview = document.getElementById('preview');
const imagePreview = document.getElementById('imagePreview');
const uploadPlaceholder = document.getElementById('upload-placeholder');

fileInput.addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        handleFile(file);
    }
});

function handleFile(file) {
    if (file && file.type.startsWith('image/')) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            // Use opacity/css for smooth transition
            uploadPlaceholder.classList.add('opacity-0', 'absolute', 'pointer-events-none');
            imagePreview.style.display = 'block';
        }
        reader.readAsDataURL(file);
    }
}

function removeImage() {
    fileInput.value = '';
    preview.src = '';
    imagePreview.style.display = 'none';
    uploadPlaceholder.classList.remove('opacity-0', 'absolute', 'pointer-events-none');
}

// Drag & Drop visual feedback
dropZone.addEventListener('dragover', (e) => {
    e.preventDefault();
    dropZone.classList.add('border-indigo-500', 'bg-indigo-50');
});
dropZone.addEventListener('dragleave', () => {
    dropZone.classList.remove('border-indigo-500', 'bg-indigo-50');
});
dropZone.addEventListener('drop', (e) => {
    e.preventDefault();
    dropZone.classList.remove('border-indigo-500', 'bg-indigo-50');
    if (e.dataTransfer.files.length) {
        fileInput.files = e.dataTransfer.files;
        handleFile(e.dataTransfer.files[0]);
    }
});

// Dynamic Fields Logic
const rType = document.getElementById('redirect_type');
const rValGroup = document.getElementById('redirect_value_group');
const dynOptions = document.getElementById('dynamic_options');
const locType = document.getElementById('target_location_type');

function updateVisibility() {
    const rVal = rType.value;
    const lVal = locType.value;
    
    // Redirect Value
    const showRVal = rVal !== 'static';
    rValGroup.style.display = showRVal ? 'block' : 'none';
    
    // Location
    const showLoc = lVal !== 'all';
    document.getElementById('location_inputs').style.display = showLoc ? 'block' : 'none';
    document.getElementById('countries_group').style.display = lVal === 'country' ? 'block' : 'none';
    document.getElementById('cities_group').style.display = lVal === 'city' ? 'block' : 'none';
    
    // Container
    dynOptions.style.display = (showRVal || showLoc) ? 'block' : 'none';
}

rType.addEventListener('change', updateVisibility);
locType.addEventListener('change', updateVisibility);

// Priority Slider Sync
const pRange = document.getElementById('priorityRange');
const pDisplay = document.getElementById('priorityDisplay');
pRange.addEventListener('input', () => {
    pDisplay.textContent = pRange.value;
});

// Initial run
updateVisibility();
</script>

<style>
/* Custom animations if needed not in Tailwind */
@keyframes fadeInDown {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}
.animate-fade-in-down {
    animation: fadeInDown 0.3s ease-out forwards;
}
</style>
@endsection
