@extends('admin.layouts.app')

@section('title', 'Banner Analytics')

@section('content')
<div class="container-fluid px-4 py-4" style="background: #f8f9fc;">
    <div class="d-flex justify-content-between align-items-center mb-5">
        <div>
            <h1 class="h3 mb-1 font-weight-bolder text-dark">Analytics Dashboard</h1>
            <p class="text-muted mb-0 font-weight-medium">Real-time performance insights for your campaigns.</p>
        </div>
        <div class="bg-white p-1 rounded-pill shadow-sm d-flex border">
            <button class="btn btn-sm btn-white rounded-pill px-4 font-weight-bold text-dark border-0">
                <i class="far fa-calendar mr-2 text-primary"></i> Last 30 Days
            </button>
            <div class="vr my-auto mx-2" style="height: 20px; width: 1px; bg-color: #eee;"></div>
            <button class="btn btn-sm btn-primary rounded-pill px-4 font-weight-bold shadow-sm">
                Refresh
            </button>
        </div>
    </div>

    <!-- Hero Stats Row -->
    <div class="card border-0 shadow-lg rounded-xl mb-4 overflow-hidden">
        <div class="card-body p-0">
            <div class="row no-gutters text-center divide-x">
                <!-- Impressions -->
                <div class="col-md py-4 p-3 hover-bg-light transition-all">
                    <div class="d-inline-flex align-items-center justify-content-center width-50 height-50 rounded-circle bg-primary-subtle text-primary mb-3 shadow-sm">
                        <i class="fas fa-eye fa-lg"></i>
                    </div>
                    <div class="h3 mb-0 font-weight-bolder text-dark">{{ number_format($stats['total_impressions']) }}</div>
                    <div class="text-xs text-uppercase font-weight-bold text-muted tracking-wider mt-1">Total Impressions</div>
                </div>
                <!-- Clicks -->
                <div class="col-md py-4 p-3 hover-bg-light transition-all">
                    <div class="d-inline-flex align-items-center justify-content-center width-50 height-50 rounded-circle bg-success-subtle text-success mb-3 shadow-sm">
                        <i class="fas fa-mouse-pointer fa-lg"></i>
                    </div>
                    <div class="h3 mb-0 font-weight-bolder text-dark">{{ number_format($stats['total_clicks']) }}</div>
                    <div class="text-xs text-uppercase font-weight-bold text-muted tracking-wider mt-1">Total Clicks</div>
                </div>
                <!-- CTR -->
                <div class="col-md py-4 p-3 hover-bg-light transition-all">
                    <div class="d-inline-flex align-items-center justify-content-center width-50 height-50 rounded-circle bg-info-subtle text-info mb-3 shadow-sm">
                        <i class="fas fa-percentage fa-lg"></i>
                    </div>
                    <div class="h3 mb-0 font-weight-bolder text-primary">{{ number_format($stats['average_ctr'], 2) }}%</div>
                    <div class="text-xs text-uppercase font-weight-bold text-muted tracking-wider mt-1">Avg CTR</div>
                </div>
                <!-- Revenue -->
                <div class="col-md py-4 p-3 hover-bg-light transition-all">
                    <div class="d-inline-flex align-items-center justify-content-center width-50 height-50 rounded-circle bg-warning-subtle text-warning mb-3 shadow-sm">
                        <i class="fas fa-rupee-sign fa-lg"></i>
                    </div>
                    <div class="h3 mb-0 font-weight-bolder text-dark">₹{{ number_format($stats['total_revenue'], 2) }}</div>
                    <div class="text-xs text-uppercase font-weight-bold text-muted tracking-wider mt-1">Est. Revenue</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts & Lists -->
    <div class="row">
        <!-- Main Chart -->
        <div class="col-lg-8 mb-4">
            <div class="card border-0 shadow-lg rounded-xl h-100">
                <div class="card-header bg-white border-0 pt-4 px-4 pb-0 d-flex justify-content-between align-items-center">
                    <h5 class="font-weight-bolder text-dark mb-0">Traffic Performance</h5>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-light border shadow-sm dropdown-toggle font-weight-bold text-muted" type="button">
                            Impressions
                        </button>
                    </div>
                </div>
                <div class="card-body px-4 pb-4">
                    <div class="chart-container" style="position: relative; height:350px;">
                        <canvas id="trafficChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Banners List -->
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-lg rounded-xl h-100">
                <div class="card-header bg-white border-0 pt-4 px-4 pb-0">
                    <h5 class="font-weight-bolder text-dark mb-0">Top Campaigns</h5>
                    <p class="text-muted text-xs mb-0 mt-1">Based on Click-Through Rate</p>
                </div>
                <div class="card-body p-0 pt-3">
                    <div class="list-group list-group-flush">
                        @forelse($topBanners as $banner)
                            <div class="list-group-item border-0 py-3 px-4 d-flex align-items-center hover-bg-light">
                                <div class="avatar rounded mr-3 shadow-sm" style="width: 50px; height: 30px; background-image: url('{{ $banner->image_url }}'); background-size: cover;"></div>
                                <div class="flex-grow-1 min-width-0">
                                    <h6 class="mb-0 text-sm font-weight-bold text-truncate text-dark">{{ $banner->title }}</h6>
                                    <div class="d-flex align-items-center mt-1">
                                        <div class="progress flex-grow-1 mr-3" style="height: 4px; background: #edf2f9;">
                                            <div class="progress-bar bg-gradient-success" style="width: {{ min($banner->ctr * 5, 100) }}%"></div>
                                        </div>
                                        <span class="text-xs font-weight-bold text-success">{{ number_format($banner->ctr, 1) }}%</span>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-4 text-muted">No data available</div>
                        @endforelse
                    </div>
                </div>
                 <div class="card-footer bg-white border-0 text-center pb-4 pt-0">
                    <a href="{{ route('admin.banners.index') }}" class="btn btn-link text-primary font-weight-bold text-sm">View All Campaigns <i class="fas fa-arrow-right ml-1"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Utilities */
.rounded-xl { border-radius: 1rem; }
.divide-x > * + * { border-left: 1px solid #f1f3f9; }
.width-50 { width: 50px; }
.height-50 { height: 50px; }

.bg-primary-subtle { background: #ebf3ff; color: #4e73df; }
.bg-success-subtle { background: #e6fffa; color: #1cc88a; }
.bg-info-subtle { background: #e0f2fe; color: #36b9cc; }
.bg-warning-subtle { background: #fffbeb; color: #f6c23e; }

.hover-bg-light:hover { background-color: #f8f9fc; }
.transition-all { transition: all 0.3s; }

.bg-gradient-success {
    background-image: linear-gradient(135deg, #42e695 0%, #3bb2b8 100%);
}
</style>

<script>
document.addEventListener("DOMContentLoaded", function() {
    var ctx = document.getElementById("trafficChart");
    if(ctx) {
        // Gradient for chart
        var gradient = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
        gradient.addColorStop(0, 'rgba(78, 115, 223, 0.4)'); // Color at top
        gradient.addColorStop(1, 'rgba(78, 115, 223, 0.01)'); // Color at bottom

        new Chart(ctx, {
            type: 'line',
            data: {
                labels: ["Week 1", "Week 2", "Week 3", "Week 4", "Week 5"],
                datasets: [{
                    label: "Impressions",
                    backgroundColor: gradient,
                    borderColor: "#4e73df",
                    data: [1000, 2500, 1800, 3200, 4500],
                    pointBackgroundColor: "#fff",
                    pointBorderColor: "#4e73df",
                    pointRadius: 4,
                    pointHoverRadius: 6,
                    borderWidth: 3,
                    fill: true
                }]
            },
            options: {
                maintainAspectRatio: false,
                legend: { display: false },
                tooltips: {
                    mode: 'index',
                    intersect: false,
                    backgroundColor: '#fff',
                    titleFontColor: '#2d3436',
                    bodyFontColor: '#2d3436',
                    borderColor: '#e3e6f0',
                    borderWidth: 1,
                    cornerRadius: 8,
                    xPadding: 12,
                    yPadding: 12,
                },
                scales: {
                    xAxes: [{ gridLines: { display: false, drawBorder: false }, ticks: { fontColor: '#b2bec3' } }],
                    yAxes: [{ gridLines: { color: "#f1f3f9", borderDash: [5, 5], drawBorder: false }, ticks: { padding: 10, fontColor: '#b2bec3' } }]
                },
                elements: {
                    line: { tension: 0.4 } // smooth curves
                }
            }
        });
    }
});
</script>
@endsection
