@extends('admin.layouts.app')

@section('content')
<style>
    /* Modern Glassmorphic Design System */
    :root {
        --glass-bg: rgba(255, 255, 255, 0.65);
        --glass-border: 1px solid rgba(255, 255, 255, 0.4);
        --glass-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.1);
        --blur: blur(20px);
        --primary-gradient: linear-gradient(135deg, #FF6B6B 0%, #556270 100%);
        --accent-gradient: linear-gradient(45deg, #12c2e9, #c471ed, #f64f59);
    }

    /* Animated Background for Glass Effect */
    .glass-wrapper {
        background: linear-gradient(-45deg, #ee7752, #e73c7e, #23a6d5, #23d5ab);
        background-size: 400% 400%;
        animation: gradientBG 15s ease infinite;
        padding: 40px;
        min-height: 85vh;
        border-radius: 30px;
        font-family: 'Inter', sans-serif;
    }

    @keyframes gradientBG {
        0% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
        100% { background-position: 0% 50%; }
    }

    .glass-card {
        background: var(--glass-bg);
        backdrop-filter: var(--blur);
        -webkit-backdrop-filter: var(--blur);
        border-radius: 24px;
        border: var(--glass-border);
        box-shadow: var(--glass-shadow);
        padding: 40px;
        max-width: 1000px;
        margin: 0 auto;
        color: #2d3748;
    }

    /* Tiles System */
    .tile-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
        gap: 15px;
        margin-top: 10px;
    }

    .tile-input {
        display: none;
    }

    .tile-label {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 20px 10px;
        background: rgba(255, 255, 255, 0.5);
        border: 2px solid transparent;
        border-radius: 16px;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        text-align: center;
        height: 100%;
    }

    .tile-label i {
        font-size: 1.8rem;
        margin-bottom: 10px;
        background: -webkit-linear-gradient(45deg, #0984e3, #6c5ce7);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .tile-label span {
        font-weight: 700;
        font-size: 0.9rem;
        color: #4a5568;
    }

    .tile-input:checked + .tile-label {
        background: white;
        border-color: #6c5ce7;
        box-shadow: 0 10px 20px rgba(108, 92, 231, 0.2);
        transform: translateY(-5px);
    }

    /* Modern Inputs */
    .glass-input {
        background: rgba(255, 255, 255, 0.5);
        border: 1px solid rgba(255, 255, 255, 0.8);
        border-radius: 12px;
        padding: 16px 20px;
        width: 100%;
        outline: none;
        transition: 0.3s;
        font-size: 1rem;
        color: #2d3748;
        font-weight: 500;
    }

    .glass-input:focus {
        background: white;
        box-shadow: 0 0 0 4px rgba(255, 255, 255, 0.4);
    }

    .input-group-label {
        font-size: 0.85rem;
        font-weight: 700;
        text-transform: uppercase;
        color: #4a5568;
        letter-spacing: 0.05em;
        margin-bottom: 8px;
        display: block;
    }

    /* Glass Button */
    .btn-glass {
        background: var(--accent-gradient);
        border: none;
        border-radius: 50px;
        padding: 16px 40px;
        font-size: 1.1rem;
        font-weight: 800;
        color: white;
        letter-spacing: 1px;
        text-transform: uppercase;
        cursor: pointer;
        box-shadow: 0 10px 20px rgba(196, 113, 237, 0.4);
        transition: transform 0.2s, box-shadow 0.2s;
        width: 100%;
        margin-top: 20px;
        position: relative;
        overflow: hidden;
    }

    .btn-glass::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(rgba(255,255,255,0.2), transparent);
    }

    .btn-glass:hover {
        transform: translateY(-3px);
        box-shadow: 0 15px 30px rgba(196, 113, 237, 0.6);
    }

    .header-text {
        color: white;
        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
        margin-bottom: 30px;
        font-weight: 800;
        text-align: center;
    }

    /* Custom Select */
    .glass-select {
        appearance: none;
        background-image: url("data:image/svg+xml;charset=US-ASCII,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%22292.4%22%20height%3D%22292.4%22%3E%3Cpath%20fill%3D%22%236c5ce7%22%20d%3D%22M287%2069.4a17.6%2017.6%200%200%200-13-5.4H18.4c-5%200-9.3%201.8-12.9%205.4A17.6%2017.6%200%200%200%200%2082.2c0%205%201.8%209.3%205.4%2012.9l128%20127.9c3.6%203.6%207.8%205.4%2012.8%205.4s9.2-1.8%2012.8-5.4L287%2095c3.5-3.5%205.4-7.8%205.4-12.8%200-5-1.9-9.2-5.5-12.8z%22%2F%3E%3C%2Fsvg%3E");
        background-repeat: no-repeat;
        background-position: right 1rem center;
        background-size: 0.8rem auto;
    }
</style>

<div class="container-fluid p-0">
    <div class="glass-wrapper">
        <h1 class="header-text display-4">✨ Create New Listing</h1>
        
        <form action="{{ route('admin.ads.store') }}" method="POST">
            @csrf
            
            <div class="glass-card">
                @if($errors->any())
                    <div class="alert alert-danger" style="background: rgba(254, 226, 226, 0.9); border: none; border-radius: 12px; font-weight: 600;">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="row">
                    <!-- Left: Content Input -->
                    <div class="col-lg-7" style="border-right: 1px solid rgba(0,0,0,0.05);">
                        <div class="mb-4">
                            <label class="input-group-label"><i class="fas fa-magic mr-2"></i> Ad Title</label>
                            <input type="text" name="title" class="glass-input" placeholder="Enter a catchy title..." value="{{ old('title') }}" required>
                        </div>

                        <div class="mb-4">
                            <label class="input-group-label"><i class="fas fa-align-left mr-2"></i> Description</label>
                            <textarea name="description" class="glass-input" rows="6" placeholder="Describe your item in detail..." required>{{ old('description') }}</textarea>
                        </div>

                        <!-- Price Tile -->
                        <div class="mb-4">
                            <label class="input-group-label"><i class="fas fa-coins mr-2"></i> Pricing & Currency</label>
                            <div class="d-flex gap-3">
                                <div style="flex: 2;">
                                    <input type="number" name="price" class="glass-input" placeholder="0.00" step="0.01" value="{{ old('price') }}" required>
                                </div>
                                <div style="flex: 1;">
                                    <select name="currency" class="glass-input glass-select">
                                        <option value="USD">USD</option>
                                        <option value="EUR">EUR</option>
                                        <option value="INR">INR</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right: Selection Tiles -->
                    <div class="col-lg-5 pl-lg-5">
                        
                        <!-- Status Tiles -->
                        <div class="mb-4">
                            <label class="input-group-label"><i class="fas fa-toggle-on mr-2"></i> Status</label>
                            <div class="tile-grid" style="grid-template-columns: 1fr 1fr;">
                                <div>
                                    <input type="radio" name="status" id="status_active" value="Active" class="tile-input" checked>
                                    <label for="status_active" class="tile-label">
                                        <i class="fas fa-check-circle" style="background: -webkit-linear-gradient(45deg, #00b09b, #96c93d); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"></i>
                                        <span>Active</span>
                                    </label>
                                </div>
                                <div>
                                    <input type="radio" name="status" id="status_pending" value="Pending" class="tile-input">
                                    <label for="status_pending" class="tile-label">
                                        <i class="fas fa-clock" style="background: -webkit-linear-gradient(45deg, #f12711, #f5af19); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"></i>
                                        <span>Pending</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- User Select -->
                        <div class="mb-4">
                            <label class="input-group-label"><i class="fas fa-user-circle mr-2"></i> Seller</label>
                            <select name="user_id" class="glass-input glass-select" required>
                                <option value="">Choose Seller...</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Category Select -->
                        <div class="mb-4">
                            <label class="input-group-label"><i class="fas fa-layer-group mr-2"></i> Category</label>
                            <select name="category_id" class="glass-input glass-select" required>
                                <option value="">Choose Category...</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Location Mini-Form -->
                        <div class="mb-4 p-3" style="background: rgba(255,255,255,0.4); border-radius: 16px;">
                            <label class="input-group-label mb-3"><i class="fas fa-map-marker-alt mr-2"></i> Location Details</label>
                            <div class="row g-2">
                                <div class="col-6">
                                    <select name="location_city" class="glass-input glass-select" style="padding: 10px; font-size: 0.9rem;">
                                        <option value="Los Angeles">Los Angeles</option>
                                        <option value="New York">New York</option>
                                        <option value="Chicago">Chicago</option>
                                    </select>
                                </div>
                                <div class="col-6">
                                    <select name="location_state" class="glass-input glass-select" style="padding: 10px; font-size: 0.9rem;">
                                        <option value="CA">California</option>
                                        <option value="NY">New York</option>
                                        <option value="IL">Illinois</option>
                                    </select>
                                </div>
                            </div>
                            <input type="hidden" name="location_country" value="USA">
                        </div>

                    </div>
                </div>

                <button type="submit" class="btn-glass">
                    🚀 Launch Listing
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
