<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// 1. Drop Tables (Order matters due to FK)
Schema::disableForeignKeyConstraints();
Schema::dropIfExists('ad_package_purchases');
Schema::dropIfExists('package_pricing_tiers');
Schema::dropIfExists('ad_packages');
Schema::enableForeignKeyConstraints();

echo "Dropped tables.\n";

// 2. Clear from migrations table
DB::table('migrations')->where('migration', 'like', '%create_ad_packages_table%')->delete();
DB::table('migrations')->where('migration', 'like', '%create_package_pricing_tiers_table%')->delete();
DB::table('migrations')->where('migration', 'like', '%create_ad_package_purchases_table%')->delete();

echo "Cleared migrations.\n";
