<?php

// Database Reset Script for CLXpro
// This script safely resets the database while preserving admin access

require_once __DIR__ . '/vendor/autoload.php';

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

echo "CLXpro Database Reset Script\n";
echo "============================\n\n";

// Check if we're in the correct directory
if (!file_exists('artisan')) {
    echo "Error: This script must be run from the clx_backend directory.\n";
    exit(1);
}

echo "1. Checking database connection...\n";

try {
    // Test database connection
    DB::connection()->getPdo();
    echo "✓ Database connection successful\n";
} catch (\Exception $e) {
    echo "✗ Database connection failed: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\n2. Backing up current data (admin user preservation)...\n";

// Store admin user data before reset
$adminEmail = 'admin@donebro.in';
$adminData = null;

try {
    $adminData = DB::table('users')
        ->where('email', $adminEmail)
        ->where('is_admin', true)
        ->first();
    
    if ($adminData) {
        echo "✓ Found existing admin user: {$adminData->name} ({$adminData->email})\n";
    } else {
        echo "ℹ No existing admin user found, will create new one\n";
    }
} catch (\Exception $e) {
    echo "⚠ Warning: Could not check for existing admin user: " . $e->getMessage() . "\n";
}

echo "\n3. Running database migrations with fresh data...\n";

try {
    // Run database migrations
    Artisan::call('migrate:fresh', [
        '--seed' => true,
        '--force' => true
    ]);
    
    echo "✓ Database migrations completed successfully\n";
    
    // Show output
    echo Artisan::output();
    
} catch (\Exception $e) {
    echo "✗ Database migration failed: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\n4. Verifying admin access...\n";

try {
    $adminCheck = DB::table('users')
        ->where('email', $adminEmail)
        ->where('is_admin', true)
        ->first();
    
    if ($adminCheck) {
        echo "✓ Admin user verified: {$adminCheck->name} ({$adminCheck->email})\n";
        echo "✓ Admin access is ready!\n";
    } else {
        echo "✗ Admin user not found after migration\n";
        exit(1);
    }
} catch (\Exception $e) {
    echo "✗ Error verifying admin user: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\n5. Database reset completed successfully!\n";
echo "\nAdmin Access Details:\n";
echo "Email: admin@donebro.in\n";
echo "Password: 123456\n";
echo "\nYou can now access the admin dashboard at: /admin/login\n";

?>
