<?php

// Fix User Plans Table Script
require_once __DIR__ . '/vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

echo "Fixing User Plans Table...\n";
echo "============================\n\n";

// Check if we're in the correct directory
if (!file_exists('artisan')) {
    echo "Error: This script must be run from the clx_backend directory.\n";
    exit(1);
}

try {
    // Test database connection
    DB::connection()->getPdo();
    echo "✓ Database connection successful\n";
} catch (\Exception $e) {
    echo "✗ Database connection failed: " . $e->getMessage() . "\n";
    exit(1);
}

// Check if user_plans table exists
$tableExists = DB::select("SHOW TABLES LIKE 'user_plans'");
$tableExists = !empty($tableExists);

if (!$tableExists) {
    echo "Creating user_plans table...\n";
    
    // Create the table
    DB::statement("
        CREATE TABLE `user_plans` (
            `id` bigint unsigned NOT NULL AUTO_INCREMENT,
            `plan_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
            `price` decimal(10,2) NOT NULL DEFAULT '0.00',
            `price_multiplier` decimal(5,2) NOT NULL DEFAULT '1.00',
            `duration_days` int NOT NULL DEFAULT '30',
            `city_multiplier` decimal(5,2) NOT NULL DEFAULT '1.00',
            `post_limit` int DEFAULT NULL,
            `lead_limit` int DEFAULT NULL,
            `analytics_tier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'basic',
            `validity_days` int NOT NULL DEFAULT '30',
            `ad_free` tinyint(1) NOT NULL DEFAULT '0',
            `has_analytics` tinyint(1) NOT NULL DEFAULT '0',
            `verified_badge` tinyint(1) NOT NULL DEFAULT '0',
            `badge_style` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
            `theme` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
            `halo_effect` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
            `ad_border` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
            `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
            `created_at` timestamp NULL DEFAULT NULL,
            `updated_at` timestamp NULL DEFAULT NULL,
            `deleted_at` timestamp NULL DEFAULT NULL,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ");
    
    echo "✓ user_plans table created successfully\n";
} else {
    echo "✓ user_plans table already exists\n";
}

// Check if we have data
$stmt = DB::select("SELECT COUNT(*) as count FROM user_plans");
$count = $stmt[0]->count;

if ($count == 0) {
    echo "Seeding user_plans table with premium plans...\n";
    
    // Insert the premium plans
    $inserts = [
        "INSERT INTO user_plans (plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, validity_days, ad_free, has_analytics, verified_badge, theme, status, created_at, updated_at) VALUES ('Standard', 0.00, 30, 5, 10, 'basic', 30, 0, 1, 0, 'standard', 'Active', NOW(), NOW())",
        "INSERT INTO user_plans (plan_name, price, duration_days, analytics_tier, validity_days, ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status, created_at, updated_at) VALUES ('VIP Buyer', 19.99, 30, 'advanced', 30, 0, 1, 1, 'blue_vip', 'vip_buyer_theme', 'blue_glow', 'blue_border', 'Active', NOW(), NOW())",
        "INSERT INTO user_plans (plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, validity_days, ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status, created_at, updated_at) VALUES ('VIP Seller', 24.99, 30, 50, 100, 'premium', 30, 0, 1, 1, 'gold_vip', 'vip_seller_theme', 'gold_glow', 'gold_border', 'Active', NOW(), NOW())",
        "INSERT INTO user_plans (plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, validity_days, ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status, created_at, updated_at) VALUES ('VIP Pro', 39.99, 30, 200, 500, 'enterprise', 30, 1, 1, 1, 'purple_premium', 'vip_pro_theme', 'purple_glow', 'purple_border', 'Active', NOW(), NOW())"
    ];
    
    foreach ($inserts as $sql) {
        DB::statement($sql);
    }
    
    echo "✓ Premium plans inserted successfully\n";
} else {
    echo "✓ user_plans table already contains data\n";
}

// Verify and display results
$stmt = DB::select("SELECT plan_name, price, status FROM user_plans ORDER BY price DESC");
echo "\n📋 Your Premium Plans:\n";
foreach ($stmt as $plan) {
    echo "  • {$plan->plan_name}: ₹{$plan->price} ({$plan->status})\n";
}

echo "\n✓ User Plans table fix completed successfully!\n";
echo "\nYou can now access: http://127.0.0.1:8000/admin/plans\n";

?>
