<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "Updating pages to show in app...\n";
$count = DB::table('pages')
    ->where('is_active', true)
    -> update(['show_in_app' => true]);

echo "Updated {$count} pages to show_in_app = true\n";

// Show current pages
$pages = DB::table('pages')->get(['title', 'slug', 'is_active', 'show_in_app']);
echo "\nCurrent pages:\n";
foreach ($pages as $page) {
    echo "- {$page->title} ({$page->slug}) - Active: " . ($page->is_active ? 'YES' : 'NO') . 
         ", Show in App: " . ($page->show_in_app ? 'YES' : 'NO') . "\n";
}
