<?php
try {
    $dbPath = __DIR__ . '/database/database.sqlite';
    if (!file_exists($dbPath)) {
        // Fallback for some Laravel structures
        $dbPath = __DIR__ . '/storage/database.sqlite';
    }
    
    if (!file_exists($dbPath)) {
        die("Database file not found at $dbPath\n");
    }

    $pdo = new PDO("sqlite:$dbPath");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Enable WAL mode
    $pdo->exec('PRAGMA journal_mode = WAL;');
    $pdo->exec('PRAGMA busy_timeout = 5000;');
    $pdo->exec('PRAGMA synchronous = NORMAL;');

    echo "Success: SQLite Journal Mode set to WAL.\n";
    
    // Check strict mode (foreign keys)
    $pdo->exec('PRAGMA foreign_keys = OFF;');
    echo "Success: Foreign Keys disabled for seeding session.\n";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}
