<?php
// Direct database fix script - bypass Laravel framework issues
// Run this: http://127.0.0.1:8000/fix_database.php

header('Content-Type: text/html; charset=utf-8');

echo "<!DOCTYPE html>
<html>
<head>
    <title>Fix Database - CLXpro</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f8fafc; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .success { color: #10b981; font-weight: bold; }
        .error { color: #ef4444; font-weight: bold; }
        .info { color: #3b82f6; font-weight: bold; }
        .btn { background: #7c3aed; color: white; padding: 12px 24px; border: none; border-radius: 6px; cursor: pointer; font-size: 16px; text-decoration: none; display: inline-block; margin: 10px 0; }
        .btn:hover { background: #6d28d9; }
        code { background: #f1f5f9; padding: 2px 6px; border-radius: 4px; font-family: monospace; }
    </style>
</head>
<body>
<div class='container'>
    <h1>🔧 CLXpro Database Fix</h1>
    <p>Fixing the user_plans table issue...</p>";

// Try to find the database file
$databasePath = null;
$possiblePaths = [
    __DIR__ . '/database/database.sqlite',
    __DIR__ . '/../database/database.sqlite',
    __DIR__ . '/storage/database.sqlite',
    getcwd() . '/database/database.sqlite'
];

foreach ($possiblePaths as $path) {
    if (file_exists($path)) {
        $databasePath = $path;
        break;
    }
}

if (!$databasePath) {
    echo "<p class='error'>❌ Could not find SQLite database file. Please check your database configuration.</p>";
    echo "<p>Looked in these paths:</p><ul>";
    foreach ($possiblePaths as $path) {
        echo "<li>$path</li>";
    }
    echo "</ul>";
    exit;
}

echo "<p class='info'>📁 Found database at: <code>$databasePath</code></p>";

try {
    // Connect to SQLite database
    $pdo = new PDO("sqlite:$databasePath");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<p class='success'>✅ Connected to database successfully!</p>";
    
    // Check if user_plans table exists
    $stmt = $pdo->query("SELECT name FROM sqlite_master WHERE type='table' AND name='user_plans';");
    $tableExists = $stmt->fetch();
    
    if (!$tableExists) {
        echo "<p>Creating user_plans table...</p>";
        
        // Create the table
        $sql = "CREATE TABLE user_plans (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            plan_name TEXT NOT NULL,
            price DECIMAL(10,2) DEFAULT 0.00,
            price_multiplier DECIMAL(5,2) DEFAULT 1.00,
            duration_days INTEGER DEFAULT 30,
            city_multiplier DECIMAL(5,2) DEFAULT 1.00,
            post_limit INTEGER NULL,
            lead_limit INTEGER NULL,
            analytics_tier TEXT DEFAULT 'basic',
            validity_days INTEGER DEFAULT 30,
            ad_free BOOLEAN DEFAULT 0,
            has_analytics BOOLEAN DEFAULT 0,
            verified_badge BOOLEAN DEFAULT 0,
            badge_style TEXT NULL,
            theme TEXT NULL,
            halo_effect TEXT NULL,
            ad_border TEXT NULL,
            status TEXT DEFAULT 'Active',
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            deleted_at DATETIME NULL
        )";
        
        $pdo->exec($sql);
        echo "<p class='success'>✅ Table 'user_plans' created successfully!</p>";
    } else {
        echo "<p class='info'>ℹ️ Table 'user_plans' already exists</p>";
    }
    
    // Check if we have data
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM user_plans");
    $rowCount = $stmt->fetch(PDO::FETCH_ASSOC);
    $count = $rowCount['count'];
    
    if ($count == 0) {
        echo "<p>Inserting sample data...</p>";
        
        // Insert sample data
        $inserts = [
            "INSERT INTO user_plans (plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, validity_days, ad_free, has_analytics, verified_badge, theme, status) VALUES ('Standard', 0.00, 30, 5, 10, 'basic', 30, 0, 1, 0, 'standard', 'Active')",
            "INSERT INTO user_plans (plan_name, price, duration_days, analytics_tier, validity_days, ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status) VALUES ('VIP Buyer', 19.99, 30, 'advanced', 30, 0, 1, 1, 'blue_vip', 'vip_buyer_theme', 'blue_glow', 'blue_border', 'Active')",
            "INSERT INTO user_plans (plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, validity_days, ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status) VALUES ('VIP Seller', 24.99, 30, 50, 100, 'premium', 30, 0, 1, 1, 'gold_vip', 'vip_seller_theme', 'gold_glow', 'gold_border', 'Active')",
            "INSERT INTO user_plans (plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, validity_days, ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status) VALUES ('VIP Pro', 39.99, 30, 200, 500, 'enterprise', 30, 1, 1, 1, 'purple_premium', 'vip_pro_theme', 'purple_glow', 'purple_border', 'Active')"
        ];
        
        foreach ($inserts as $sql) {
            $pdo->exec($sql);
        }
        
        echo "<p class='success'>✅ Sample data inserted successfully!</p>";
    } else {
        echo "<p class='info'>ℹ️ Sample data already exists ($count records)</p>";
    }
    
    // Verify the data
    $stmt = $pdo->query("SELECT plan_name, price, status FROM user_plans ORDER BY price DESC");
    $plans = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h3>📋 Your Premium Plans:</h3>";
    echo "<table border='1' style='border-collapse: collapse; width: 100%; margin: 20px 0;'>";
    echo "<tr style='background: #f1f5f9;'><th>Plan Name</th><th>Price</th><th>Status</th></tr>";
    foreach ($plans as $plan) {
        echo "<tr><td>{$plan['plan_name']}</td><td>₹{$plan['price']}</td><td>{$plan['status']}</td></tr>";
    }
    echo "</table>";
    
    echo "<h2 class='success'>🎉 SUCCESS! Your Premium Plan system is now ready!</h2>";
    echo "<p><a href='/admin/plans' class='btn'>Go to Admin Plans Dashboard →</a></p>";
    echo "<p><a href='/admin/dashboard' class='btn' style='background: #3b82f6;'>Go to Admin Dashboard</a></p>";
    
} catch (PDOException $e) {
    echo "<p class='error'>❌ Database Error: " . $e->getMessage() . "</p>";
    echo "<p>Please check your database file permissions and try again.</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "
    <hr style='margin: 30px 0;'>
    <p><strong>Manual Alternative:</strong> If this doesn't work, you can manually run the SQL from <code>database/user_plans_setup.sql</code></p>
    <p><strong>Next Steps:</strong></p>
    <ol>
        <li>Run this script to fix the database</li>
        <li>Visit <a href='/admin/plans'>/admin/plans</a> to see your premium plans</li>
        <li>Start managing your premium subscription system!</li>
    </ol>
</div>
</body>
</html>";
?>
