<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Banner;

echo "Fixing Banner Placements...\n";

$banners = Banner::whereNull('placement_screens')->orWhere('placement_screens', '[]')->get();
echo "Found " . $banners->count() . " banners to fix.\n";

foreach ($banners as $banner) {
    echo "Updating Banner ID: " . $banner->id . "\n";
    $banner->placement_screens = ['home', 'search', 'category', 'profile'];
    $banner->save();
}

echo "Done.\n";
