<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

// Find or create a VIP Pro plan with analytics
$vipPlan = DB::table('user_plans')->where('plan_name', 'LIKE', '%VIP%')->first();

if (!$vipPlan) {
    echo "⚠️  No VIP plan found, creating one...\n";
    
    $planId = DB::table('user_plans')->insertGetId([
        'plan_name' => 'VIP Pro',
        'post_limit' => -1,  // Unlimited
        'lead_limit' => -1,  // Unlimited
        'verified_badge' => 1,
        'ad_free' => 1,
        'has_analytics' => 1,
        'analytics_tier' => 'advanced',
        'expires_at' => null,  // Lifetime
        'created_at' => now(),
        'updated_at' => now(),
    ]);
    
    $vipPlan = DB::table('user_plans')->find($planId);
    echo "✅ Created VIP Pro plan (ID: $planId)\n";
} else {
    // Update existing plan to have analytics
    DB::table('user_plans')->where('id', $vipPlan->id)->update([
        'has_analytics' => 1,
        'analytics_tier' => 'advanced'
    ]);
    echo "✅ Updated existing plan: {$vipPlan->plan_name} (ID: {$vipPlan->id})\n";
}

// Assign plan to user ID 1
DB::table('users')->where('id', 1)->update([
    'current_plan_id' => $vipPlan->id
]);

echo "✅ Assigned VIP Pro plan to user ID 1\n";
echo "\n🎉 Done! Press 'r' in the terminal to hot reload the Flutter app!\n";
