<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "\n--- DEBUGER: User Plans & Limits ---\n";

$users = App\Models\User::with('currentPlan')->take(10)->get();

foreach ($users as $u) {
    echo "User [{$u->id}]: {$u->name} ({$u->email})\n";
    
    $plan = $u->currentPlan;
    if ($plan) {
        echo "  - Plan: {$plan->plan_name} (ID: {$plan->id})\n";
        echo "  - Lead Limit (Incoming): " . var_export($plan->lead_limit, true) . "\n";
        echo "  - Contact Limit (Outgoing): " . var_export($plan->contact_limit, true) . "\n";
    } else {
        echo "  - Plan: NONE\n";
    }
    
    echo "  - Leads Received: {$u->leads_received}\n";
    echo "  - Contacts Initiated: {$u->contacts_initiated}\n";
    echo "------------------------------------------------\n";
}
