<?php

use App\Models\User;
use Illuminate\Support\Facades\DB;

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Get the latest user or a specific test user
$user = User::where('email', 'like', '%test%')->first() ?? User::latest()->first();

if (!$user) {
    echo "No user found.\n";
    exit;
}

echo "Checking User: " . $user->name . " (" . $user->email . ")\n";

// Manually load the relationship to mimic the API behavior
$user->load('currentPlan');

// Output relevant details
echo "Current Plan ID: " . ($user->current_plan_id ?? 'NULL') . "\n";

if ($user->currentPlan) {
    echo "Plan Name: " . $user->currentPlan->plan_name . "\n";
    echo "Theme: " . $user->currentPlan->theme . "\n";
    echo "Badge Style: " . $user->currentPlan->badge_style . "\n";
    echo "Analytics Tier: " . $user->currentPlan->analytics_tier . "\n";
    
    // Dump the full plan structure as array
    echo "\nFull Plan Attributes:\n";
    print_r($user->currentPlan->toArray());
} else {
    echo "User has no active plan.\n";
}
