<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();


use App\Models\UserPlan;
use Illuminate\Support\Facades\Log;

// 1. Fetch a plan
$plan = UserPlan::first();

if (!$plan) {
    echo "No plans found in database.\n";
    exit;
}

echo "Found Plan: " . $plan->plan_name . " (ID: " . $plan->id . ")\n";
echo "Current Status: " . $plan->status . "\n";

// 2. Simulate Logic
try {
    $plan->status = $plan->status === 'Active' ? 'Inactive' : 'Active';
    $plan->save();
    echo "SUCCESS: Status changed to: " . $plan->status . "\n";
} catch (\Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString();
}

// 3. Verify Persistence
$check = UserPlan::find($plan->id);
echo "Verified Status in DB: " . $check->status . "\n";
