<?php
use App\Models\Ad;
use App\Models\AlgorithmConfig;

$query = Ad::active()
    ->where('title', 'LIKE', 'TEST_RANKING_%')
    ->orderByInterestAndLocation(12.9716, 77.5946);

echo "SQL: " . $query->toSql() . "\n";
echo "Bindings: " . json_encode($query->getBindings()) . "\n";

try {
    $results = $query->get();
    foreach ($results as $ad) {
        $score = $ad->relevance_score;
        echo "Ad: {$ad->title} | Score: " . var_export($score, true) . "\n";
    }
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
