<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// 1. Login to get token (simulated)
$email = 'test@clxpro.com';
$password = 'password123';

if (!Auth::attempt(['email' => $email, 'password' => $password])) {
    echo "Login failed!\n";
    exit;
}

$user = Auth::user();
echo "Logged in as User ID: " . $user->id . "\n";

// 2.  Directly call controller method (simulating API request)
// We instantiate the controller and call the method to see what query it runs
// and what it returns.

$request = Request::create('/api/v1/my-ads', 'GET');
$request->setUserResolver(function () use ($user) {
    return $user;
});

$controller = new \App\Http\Controllers\Api\AdController();
try {
    $response = $controller->getMyAds($request);
    
    $content = $response->getContent();
    $data = json_decode($content, true);
    
    echo "API Status Code: " . $response->getStatusCode() . "\n";
    echo "Ads Found in Response: " . count($data['data'] ?? []) . "\n";
    
    if (isset($data['data']) && count($data['data']) > 0) {
        foreach ($data['data'] as $ad) {
            echo "- Ad: {$ad['title']} | Status: {$ad['status']} | ID: {$ad['id']}\n";
        }
    } else {
        echo "Response Data: " . substr($content, 0, 500) . "\n";
    }

} catch (\Exception $e) {
    echo "Controller Error: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString();
}
