<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\AdNetwork;
use App\Models\AdUnit;

echo "--- DEBUG START ---\n";

echo "Check Ad Networks:\n";
$networks = AdNetwork::all();
foreach ($networks as $n) {
    echo "Network: {$n->name}, ID: {$n->id}, Active: {$n->is_active}, Priority: {$n->priority}\n";
}

echo "\nCheck Ad Units:\n";
$units = AdUnit::all();
foreach ($units as $u) {
    echo "Unit: {$u->name}, ID: {$u->id}, Placement: {$u->placement_identifier}, Active: {$u->is_active}, NetworkID: {$u->ad_network_id}\n";
}

echo "\nCheck Controller Logic Simulation:\n";
$activeUnits = AdUnit::where('is_active', true)
    ->whereHas('network', function ($query) {
        $query->where('is_active', true);
    })
    ->get();

echo "Active Units returned by Controller Logic: " . $activeUnits->count() . "\n";
foreach ($activeUnits as $au) {
    echo " - {$au->name} ({$au->placement_identifier})\n";
}

echo "--- DEBUG END ---\n";
