<?php
use App\Models\User;
use App\Models\UserPlan;

$users = User::with('currentPlan')->take(5)->get();

echo "--- Debugging User Limits ---\n";

foreach ($users as $user) {
    echo "User ID: " . $user->id . " (" . $user->name . ")\n";
    $plan = $user->currentPlan;
    
    if ($plan) {
        echo "  Plan: " . $plan->plan_name . "\n";
        echo "  Lead Limit (Seller Incoming): " . var_export($plan->lead_limit, true) . "\n";
        echo "  Contact Limit (Buyer Outgoing): " . var_export($plan->contact_limit, true) . "\n";
    } else {
        echo "  Plan: None (Default Defaults)\n";
    }
    
    echo "  Leads Received: " . $user->leads_received . "\n";
    echo "  Contacts Initiated: " . $user->contacts_initiated . "\n";
    echo "---------------------------\n";
}
