<?php

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

try {
    Log::info('DebugScript: Starting request...');
    
    // Call SELF
    $response = Http::get('http://127.0.0.1:8000/api/v1/ads', [
        'latitude' => 40.7128,
        'longitude' => -74.0060,
        'radius' => 100
    ]);

    echo "Status: " . $response->status() . "\n";
    echo "Body Length: " . strlen($response->body()) . "\n";
    
    if ($response->successful()) {
        $json = $response->json();
        $count = count($json['data'] ?? []);
        echo "Ads found: $count\n";
    } else {
        echo "Error: " . $response->body() . "\n";
    }
    
    Log::info('DebugScript: Finished request.');

} catch (\Exception $e) {
    echo "Exception: " . $e->getMessage() . "\n";
}
