<?php
// Load Laravel
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Category;

use App\Models\Subcategory;
$s = Subcategory::where('slug', 'mobile-phones')->with('category')->first();
if ($s) {
    echo "Slug 'mobile-phones' belongs to Category: '" . $s->category->name . "'\n";
} else {
    echo "Slug 'mobile-phones' NOT FOUND.\n";
}

$terms = ['Car%', '%Apartment%', '%Sofa%'];
foreach ($terms as $term) {
    echo "Searching for $term:\n";
    $subs = Subcategory::where('name', 'like', $term)->with('category')->get();
    foreach ($subs as $s) {
         echo " - Found '" . $s->name . "' in Category '" . $s->category->name . "'\n";
    }
}
