<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Banner;
use Carbon\Carbon;

echo "Checking Banners...\n";

$banners = Banner::all();
echo "Total Banners: " . $banners->count() . "\n";

foreach ($banners as $banner) {
    echo "ID: " . $banner->id . "\n";
    echo "Title: " . $banner->title . "\n";
    echo "Status: " . $banner->status . "\n";
    echo "Start Date: " . $banner->start_date . "\n";
    echo "End Date: " . ($banner->end_date ?? 'NULL') . "\n";
    echo "Placement Screens: " . json_encode($banner->placement_screens) . "\n";
    echo "Target Location: " . $banner->target_location_type . "\n";
    echo "Target Countries: " . json_encode($banner->target_countries) . "\n";
    echo "Total Impressions: " . $banner->total_impressions . "\n";
    echo "Views Limit: " . ($banner->views_limit ?? 'NULL') . "\n";
    
    // Check if it should be active
    $isActive = $banner->status === 'active';
    $isStarted = $banner->start_date <= now();
    $isNotEnded = !$banner->end_date || $banner->end_date >= now();
    $hasImpressionsLeft = !$banner->views_limit || $banner->total_impressions < $banner->views_limit;
    
    echo "Calculated Active: " . ($isActive && $isStarted && $isNotEnded && $hasImpressionsLeft ? 'YES' : 'NO') . "\n";
    if (!$isActive) echo " - Status is not active\n";
    if (!$isStarted) echo " - Not started yet\n";
    if (!$isNotEnded) echo " - Ended\n";
    if (!$hasImpressionsLeft) echo " - No impressions left\n";
    
    echo "--------------------------------\n";
}
