<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Http\Request;
use App\Http\Controllers\Api\BannerDisplayController;

// Simulate Request
$request = Request::create('/api/banners/active', 'GET', ['country' => 'IN']);

// Resolve Controller
$controller = app(BannerDisplayController::class);

// Call Method
$response = $controller->getActiveBanners($request);

echo "--- API Response Body ---\n";
echo json_encode($response->getData(), JSON_PRETTY_PRINT);
echo "\n-------------------------\n";

// Also check raw query if possible (manually reconstructing for debug)
echo "--- Manual Query Check ---\n";
$banners = \App\Models\Banner::active()
    ->forLocation('IN', null, null)
    ->where(function ($query) {
        $query->whereColumn('spent_amount', '<', 'total_budget')
                ->orWhere('is_admin_created', true);
    })
    ->get();

echo "Count from Manual Query: " . $banners->count() . "\n";
foreach ($banners as $b) {
    echo "Banner ID: {$b->id} | Status: {$b->status} | Budget: {$b->total_budget} | Spent: {$b->spent_amount} | Admin: {$b->is_admin_created}\n";
}
