<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;
use App\Models\Ad;

$email = 'demo_vip_pro@clxpro.com';
$user = User::where('email', $email)->first();

if (!$user) {
    echo "User $email NOT FOUND.\n";
    exit;
}

echo "User ID: " . $user->id . "\n";
$ads = Ad::where('user_id', $user->id)->get();

echo "Found " . $ads->count() . " ads for user.\n";

foreach ($ads as $ad) {
    echo "[{$ad->id}] {$ad->title} (Status: {$ad->status})\n";
    echo "   - Images count: " . $ad->images()->count() . "\n";
    foreach ($ad->images as $img) {
         echo "     - " . $img->image_path . "\n";
    }
}
