-- Create user_plans table
CREATE TABLE user_plans (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    plan_name TEXT NOT NULL,
    price DECIMAL(10,2) DEFAULT 0.00,
    price_multiplier DECIMAL(5,2) DEFAULT 1.00,
    duration_days INTEGER DEFAULT 30,
    city_multiplier DECIMAL(5,2) DEFAULT 1.00,
    post_limit INTEGER NULL,
    lead_limit INTEGER NULL,
    analytics_tier TEXT DEFAULT 'basic',
    validity_days INTEGER DEFAULT 30,
    ad_free BOOLEAN DEFAULT 0,
    has_analytics BOOLEAN DEFAULT 0,
    verified_badge BOOLEAN DEFAULT 0,
    badge_style TEXT NULL,
    theme TEXT NULL,
    halo_effect TEXT NULL,
    ad_border TEXT NULL,
    status TEXT DEFAULT 'Active',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    deleted_at DATETIME NULL
);

-- Insert Standard Plan (Free)
INSERT INTO user_plans (
    plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, 
    validity_days, ad_free, has_analytics, verified_badge, theme, status
) VALUES (
    'Standard', 0.00, 30, 5, 10, 'basic', 30, 0, 1, 0, 'standard', 'Active'
);

-- Insert VIP Buyer Plan
INSERT INTO user_plans (
    plan_name, price, duration_days, analytics_tier, validity_days, 
    ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status
) VALUES (
    'VIP Buyer', 19.99, 30, 'advanced', 30, 0, 1, 1, 'blue_vip', 'vip_buyer_theme', 'blue_glow', 'blue_border', 'Active'
);

-- Insert VIP Seller Plan
INSERT INTO user_plans (
    plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, 
    validity_days, ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status
) VALUES (
    'VIP Seller', 24.99, 30, 50, 100, 'premium', 30, 0, 1, 1, 'gold_vip', 'vip_seller_theme', 'gold_glow', 'gold_border', 'Active'
);

-- Insert VIP Pro Plan
INSERT INTO user_plans (
    plan_name, price, duration_days, post_limit, lead_limit, analytics_tier, 
    validity_days, ad_free, has_analytics, verified_badge, badge_style, theme, halo_effect, ad_border, status
) VALUES (
    'VIP Pro', 39.99, 30, 200, 500, 'enterprise', 30, 1, 1, 1, 'purple_premium', 'vip_pro_theme', 'purple_glow', 'purple_border', 'Active'
);
