<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserPlansSeeder extends Seeder
{
    public function run(): void
    {
        // Clear existing plans (use delete instead of truncate to avoid FK constraints)
        DB::table('user_plans')->delete();

        // Standard Plan (Free)
        DB::table('user_plans')->insert([
            'plan_name' => 'Standard',
            'price' => 0.00,
            'monthly_price' => 0.00,
            'quarterly_price' => 0.00,
            'half_yearly_price' => 0.00,
            'yearly_price' => 0.00,
            'billing_cycle_months' => 1,
            'discount_percentage' => 0.00,
            'discount_fixed_amount' => 0.00,
            'enable_monthly' => true,
            'enable_quarterly' => false,
            'enable_half_yearly' => false,
            'enable_yearly' => false,
            'promotion_text' => null,
            'savings_text' => null,
            'duration_days' => 30,
            'validity_days' => 30,
            'post_limit' => 10,
            'lead_limit' => 0,
            'analytics_tier' => 'basic',
            'ad_free' => false,
            'has_analytics' => true,
            'verified_badge' => false,
            'badge_style' => null,
            'theme' => 'standard',
            'halo_effect' => null,
            'ad_border' => null,
            'status' => 'Active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // VIP Buyer Plan - $4.99 (50% OFF from $9.99)
        DB::table('user_plans')->insert([
            'plan_name' => 'VIP Buyer',
            'price' => 4.99,
            'monthly_price' => 4.99,
            'quarterly_price' => 13.99,
            'half_yearly_price' => 24.99,
            'yearly_price' => 44.99,
            'billing_cycle_months' => 1,
            'discount_percentage' => 50.00,
            'discount_fixed_amount' => 5.00,
            'enable_monthly' => true,
            'enable_quarterly' => true,
            'enable_half_yearly' => true,
            'enable_yearly' => true,
            'promotion_text' => '50% OFF - LIMITED TIME!',
            'savings_text' => 'POPULAR - Save $5',
            'duration_days' => 30,
            'validity_days' => 30,
            'post_limit' => 0,
            'lead_limit' => 10,
            'analytics_tier' => 'basic',
            'ad_free' => false,
            'has_analytics' => false,
            'verified_badge' => true,
            'badge_style' => 'vip_buyer',
            'theme' => 'blue',
            'halo_effect' => null,
            'ad_border' => null,
            'status' => 'Active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // VIP Seller Plan - $9.99 (50% OFF from $19.99)
        DB::table('user_plans')->insert([
            'plan_name' => 'VIP Seller',
            'price' => 9.99,
            'monthly_price' => 9.99,
            'quarterly_price' => 26.99,
            'half_yearly_price' => 49.99,
            'yearly_price' => 89.99,
            'billing_cycle_months' => 1,
            'discount_percentage' => 50.00,
            'discount_fixed_amount' => 10.00,
            'enable_monthly' => true,
            'enable_quarterly' => true,
            'enable_half_yearly' => true,
            'enable_yearly' => true,
            'promotion_text' => '50% OFF - LIMITED TIME!',
            'savings_text' => 'Save $10 - Best for Sellers',
            'duration_days' => 30,
            'validity_days' => 30,
            'post_limit' => 10,
            'lead_limit' => 0,
            'analytics_tier' => 'advanced',
            'ad_free' => false,
            'has_analytics' => true,
            'verified_badge' => true,
            'badge_style' => 'vip_seller',
            'theme' => 'orange',
            'halo_effect' => null,
            'ad_border' => null,
            'status' => 'Active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        // VIP Pro Plan - $14.99 (50% OFF from $29.99)
        DB::table('user_plans')->insert([
            'plan_name' => 'VIP Pro',
            'price' => 14.99,
            'monthly_price' => 14.99,
            'quarterly_price' => 39.99,
            'half_yearly_price' => 74.99,
            'yearly_price' => 134.99,
            'billing_cycle_months' => 1,
            'discount_percentage' => 50.00,
            'discount_fixed_amount' => 15.00,
            'enable_monthly' => true,
            'enable_quarterly' => true,
            'enable_half_yearly' => true,
            'enable_yearly' => true,
            'promotion_text' => '50% OFF - BEST VALUE!',
            'savings_text' => 'BEST VALUE - Save $15',
            'duration_days' => 30,
            'validity_days' => 30,
            'post_limit' => 10,
            'lead_limit' => 10,
            'analytics_tier' => 'advanced',
            'ad_free' => true,
            'has_analytics' => true,
            'verified_badge' => true,
            'badge_style' => 'vip_pro',
            'theme' => 'purple',
            'halo_effect' => true,
            'ad_border' => 'gradient',
            'status' => 'Active',
            'is_default' => false,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $this->command->info('✅ User plans seeded successfully with 50% discount pricing!');
    }
}
