<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TrustScoreSettingsSeeder extends Seeder
{
    public function run()
    {
        $settings = [
            // Base & Verification
            ['key' => 'trust_score_base', 'value' => '0', 'description' => 'Starting score for new users'],
            ['key' => 'trust_score_email_verified', 'value' => '10', 'description' => 'Points for verifying email'],
            ['key' => 'trust_score_phone_verified', 'value' => '20', 'description' => 'Points for verifying phone number'],
            ['key' => 'trust_score_id_verified', 'value' => '40', 'description' => 'Points for verifying government ID'],

            // Transactional (Sales)
            ['key' => 'trust_score_per_sale', 'value' => '5', 'description' => 'Points earned per completed sale'],
            ['key' => 'trust_score_max_sales', 'value' => '40', 'description' => 'Maximum points earned from sales history'],

            // Reviews & Ratings
            ['key' => 'trust_score_per_review_star', 'value' => '2', 'description' => 'Points per star in average rating (e.g., 4.5 * 2 = 9)'],
            ['key' => 'trust_score_review_count_bonus', 'value' => '2', 'description' => 'Points per 5 reviews received'],
            ['key' => 'trust_score_max_review_points', 'value' => '30', 'description' => 'Maximum points from reviews'],

            // Penalties
            ['key' => 'trust_penalty_report', 'value' => '15', 'description' => 'Points deducted per valid safety report'],
            ['key' => 'trust_penalty_warning', 'value' => '20', 'description' => 'Points deducted per admin warning'],
            ['key' => 'trust_penalty_suspension', 'value' => '50', 'description' => 'Points deducted per account suspension'],
        ];

        foreach ($settings as $setting) {
            DB::table('settings')->updateOrInsert(
                ['key' => $setting['key']],
                [
                    'value' => $setting['value'],
                    'description' => $setting['description'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            );
        }
    }
}
