<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SafetySettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            [
                'key' => 'safety.auto_suspend_threshold',
                'value' => '5',
                'description' => 'Number of reports required to auto-suspend an ad.'
            ],
            [
                'key' => 'safety.auto_ban_threshold',
                'value' => '10',
                'description' => 'Number of sustained reports required to auto-ban a user.'
            ],
            [
                'key' => 'safety.ai_enabled',
                'value' => 'true',
                'description' => 'Enable AI-based risk scoring for reports.'
            ],
            [
                'key' => 'safety.strict_mode',
                'value' => 'false',
                'description' => 'If enabled, any "scam" report auto-suspends ad immediately.'
            ],
            [
                'key' => 'safety.scam_keywords',
                'value' => 'western union,bank transfer,paytm only,google play card,courier service',
                'description' => 'Comma-separated keywords that trigger high risk score.'
            ]
        ];

        foreach ($settings as $setting) {
            \App\Models\Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
