<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PaymentGateway;

class PaymentGatewaysSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $gateways = [
            [
                'name' => 'Stripe',
                'slug' => 'stripe',
                'description' => 'Accept credit cards and international payments via Stripe.',
                'supported_currencies' => ['USD', 'EUR', 'GBP', 'INR'],
                'is_active' => true,
                'is_test_mode' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Razorpay',
                'slug' => 'razorpay',
                'description' => 'Accept payments via UPI, Cards, Netbanking in India.',
                'supported_currencies' => ['INR'],
                'is_active' => true,
                'is_test_mode' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'PhonePe',
                'slug' => 'phonepe',
                'description' => 'Popular UPI payment gateway in India.',
                'supported_currencies' => ['INR'],
                'is_active' => false,
                'is_test_mode' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Paytm',
                'slug' => 'paytm',
                'description' => 'Trusted payment gateway for wallet and UPI payments.',
                'supported_currencies' => ['INR'],
                'is_active' => false,
                'is_test_mode' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'PayPal',
                'slug' => 'paypal',
                'description' => 'Global standard for online payments.',
                'supported_currencies' => ['USD', 'EUR', 'GBP'],
                'is_active' => false,
                'is_test_mode' => true,
                'sort_order' => 5,
            ],
        ];

        foreach ($gateways as $gateway) {
            PaymentGateway::updateOrCreate(
                ['slug' => $gateway['slug']],
                $gateway
            );
        }
    }
}
