<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Page;

class PagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            [
                'title' => 'About Us',
                'slug' => 'about-us',
                'content' => '<h1>About Us</h1><p>Welcome to CLX Pro - Your trusted classified ads platform.</p>',
                'is_active' => true,
                'is_system_page' => true,
                'show_in_app' => true,
                'order' => 1,
                'meta' => ['icon' => 'ℹ️'],
            ],
            [
                'title' => 'Terms & Conditions',
                'slug' => 'terms-and-conditions',
                'content' => '<h1>Terms & Conditions</h1><p>Please read these terms carefully before using our service.</p>',
                'is_active' => true,
                'is_system_page' => true,
                'show_in_app' => true,
                'order' => 2,
                'meta' => ['icon' => '📋'],
            ],
            [
                'title' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'content' => '<h1>Privacy Policy</h1><p>Your privacy is important to us. This policy explains how we handle your data.</p>',
                'is_active' => true,
                'is_system_page' => true,
                'show_in_app' => true,
                'order' => 3,
                'meta' => ['icon' => '🔒'],
            ],
            [
                'title' => 'Refund Policy',
                'slug' => 'refund-policy',
                'content' => '<h1>Refund Policy</h1><p>Information about our refund process and conditions.</p>',
                'is_active' => true,
                'is_system_page' => true,
                'show_in_app' => true,
                'order' => 4,
                'meta' => ['icon' => '💰'],
            ],
            [
                'title' => 'Contact Us',
                'slug' => 'contact-us',
                'content' => '<h1>Contact Us</h1><p>Get in touch with us for any questions or support.</p>',
                'is_active' => true,
                'is_system_page' => true,
                'show_in_app' => true,
                'order' => 5,
                'meta' => ['icon' => '📧'],
            ],
        ];

        foreach ($pages as $page) {
            Page::updateOrCreate(
                ['slug' => $page['slug']],
                $page
            );
        }
    }
}
