<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AdNetwork;
use App\Models\AdUnit;

class MonetizationSeeder extends Seeder
{
    public function run(): void
    {
        // Create AdMob Network
        $admob = AdNetwork::updateOrCreate(
            ['name' => 'admob'],
            [
                'display_name' => 'Google AdMob',
                'app_id' => '',  // User will fill this
                'is_active' => false,
            ]
        );

        // Create Facebook Audience Network
        $facebook = AdNetwork::updateOrCreate(
            ['name' => 'facebook'],
            [
                'display_name' => 'Facebook Audience Network',
                'app_id' => '',  // User will fill this
                'is_active' => false,
            ]
        );

        // Create Ad Units for AdMob
        $admobUnits = [
            ['name' => 'Home Banner', 'placement_identifier' => 'home_banner', 'type' => 'banner'],
            ['name' => 'Home Native Ad', 'placement_identifier' => 'home_native', 'type' => 'native'],
            ['name' => 'Home Interstitial', 'placement_identifier' => 'home_interstitial', 'type' => 'interstitial'],
            ['name' => 'Ad Details Banner', 'placement_identifier' => 'ad_details_banner', 'type' => 'banner'],
            ['name' => 'Ad Details Native', 'placement_identifier' => 'ad_details_native', 'type' => 'native'],
            ['name' => 'Ad Details Native 1 (Mid)', 'placement_identifier' => 'ad_details_mid_1', 'type' => 'native'],
            ['name' => 'Ad Details Native 2 (Map)', 'placement_identifier' => 'ad_details_mid_2', 'type' => 'native'],
            ['name' => 'Category Banner', 'placement_identifier' => 'category_banner', 'type' => 'banner'],
            ['name' => 'Category Native', 'placement_identifier' => 'category_native', 'type' => 'native'],
            ['name' => 'Category Interstitial', 'placement_identifier' => 'category_interstitial', 'type' => 'interstitial'],
            ['name' => 'Search Banner', 'placement_identifier' => 'search_banner', 'type' => 'banner'],
            ['name' => 'Search Native', 'placement_identifier' => 'search_native', 'type' => 'native'],
            ['name' => 'Post Ad Interstitial', 'placement_identifier' => 'post_ad_interstitial', 'type' => 'interstitial'],
            ['name' => 'Post Ad Rewarded', 'placement_identifier' => 'post_ad_rewarded', 'type' => 'rewarded'],
            ['name' => 'Profile Banner', 'placement_identifier' => 'profile_banner', 'type' => 'banner'],
            ['name' => 'My Ads Banner', 'placement_identifier' => 'my_ads_banner', 'type' => 'banner'],
            ['name' => 'App Open Ad', 'placement_identifier' => 'app_open', 'type' => 'app_open'],
            ['name' => 'Chat Banner', 'placement_identifier' => 'chat_banner', 'type' => 'banner'],
        ];

        foreach ($admobUnits as $unit) {
            $existing = AdUnit::where('ad_network_id', $admob->id)
                ->where('placement_identifier', $unit['placement_identifier'])
                ->first();

            if ($existing) {
                $existing->update([
                    'name' => $unit['name'],
                    'type' => $unit['type'],
                ]);
            } else {
                AdUnit::create([
                    'ad_network_id' => $admob->id,
                    'placement_identifier' => $unit['placement_identifier'],
                    'name' => $unit['name'],
                    'type' => $unit['type'],
                    'ad_unit_id' => '',
                    'is_active' => false,
                ]);
            }
        }

        // Create Ad Units for Facebook Audience Network
        // Note: Facebook doesn't officially support Rewarded or App Open ads, but we'll create placeholders
        $facebookUnits = [
            ['name' => 'Home Banner', 'placement_identifier' => 'home_banner', 'type' => 'banner'],
            ['name' => 'Home Native Ad', 'placement_identifier' => 'home_native', 'type' => 'native'],
            ['name' => 'Home Interstitial', 'placement_identifier' => 'home_interstitial', 'type' => 'interstitial'],
            ['name' => 'Ad Details Banner', 'placement_identifier' => 'ad_details_banner', 'type' => 'banner'],
            ['name' => 'Ad Details Native', 'placement_identifier' => 'ad_details_native', 'type' => 'native'],
            ['name' => 'Ad Details Native 1 (Mid)', 'placement_identifier' => 'ad_details_mid_1', 'type' => 'native'],
            ['name' => 'Ad Details Native 2 (Map)', 'placement_identifier' => 'ad_details_mid_2', 'type' => 'native'],
            ['name' => 'Category Banner', 'placement_identifier' => 'category_banner', 'type' => 'banner'],
            ['name' => 'Category Native', 'placement_identifier' => 'category_native', 'type' => 'native'],
            ['name' => 'Category Interstitial', 'placement_identifier' => 'category_interstitial', 'type' => 'interstitial'],
            ['name' => 'Search Banner', 'placement_identifier' => 'search_banner', 'type' => 'banner'],
            ['name' => 'Search Native', 'placement_identifier' => 'search_native', 'type' => 'native'],
            ['name' => 'Post Ad Interstitial', 'placement_identifier' => 'post_ad_interstitial', 'type' => 'interstitial'],
            ['name' => 'Post Ad Rewarded (Not Supported)', 'placement_identifier' => 'post_ad_rewarded', 'type' => 'rewarded'],
            ['name' => 'Profile Banner', 'placement_identifier' => 'profile_banner', 'type' => 'banner'],
            ['name' => 'My Ads Banner', 'placement_identifier' => 'my_ads_banner', 'type' => 'banner'],
            ['name' => 'App Open Ad (Not Supported)', 'placement_identifier' => 'app_open', 'type' => 'app_open'],
            ['name' => 'Chat Banner', 'placement_identifier' => 'chat_banner', 'type' => 'banner'],
        ];

        foreach ($facebookUnits as $unit) {
            $existing = AdUnit::where('ad_network_id', $facebook->id)
                ->where('placement_identifier', $unit['placement_identifier'])
                ->first();

            if ($existing) {
                $existing->update([
                    'name' => $unit['name'],
                    'type' => $unit['type'],
                ]);
            } else {
                AdUnit::create([
                    'ad_network_id' => $facebook->id,
                    'placement_identifier' => $unit['placement_identifier'],
                    'name' => $unit['name'],
                    'type' => $unit['type'],
                    'ad_unit_id' => '',
                    'is_active' => false,
                ]);
            }
        }

        $this->command->info('✅ Monetization networks and ad units created successfully!');
    }
}
