<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Ad;
use App\Models\UserPlan;
use App\Models\AdPackage;
use App\Models\PackagePricingTier;
use App\Models\Category;
use Illuminate\Support\Facades\DB;

class DemoDataSeeder extends Seeder
{
    public function run()
    {
        // 1. Create or Get User Plan
        $plan = UserPlan::firstOrCreate(
            ['plan_name' => 'Premium Plus'],
            [
                'theme' => 'purple',
                'verified_badge' => true,
                'featured_limit' => 10,
                'boost_limit' => 5,
                'post_limit' => 50,
                'ad_free' => true,
                'has_analytics' => true,
                'price' => 29.99,
                'monthly_price' => 29.99,
                'billing_cycle_months' => 1,
                'vip_badge' => true,
            ]
        );

        // 2. Create User
        $user = User::updateOrCreate(
            ['email' => 'demo@clxpro.com'],
            [
                'name' => 'Demo User',
                'password' => Hash::make('password'),
                'current_plan_id' => $plan->id,
                'featured_ads_used' => 2,
                'boost_ads_used' => 1,
                'email_verified_at' => now(),
            ]
        );

        // 3. Create Packages
        $featuredPkg = AdPackage::firstOrCreate(
            ['slug' => 'featured-ad'],
            [
                'type' => 'featured', 
                'name' => 'Featured Ad',
                'description' => 'Get up to 5x more views', 
                'is_active' => true, 
                'sort_order' => 1, 
                'features' => json_encode(['highlight' => true]),
                'algorithm_params' => json_encode([]),
            ]
        );
        PackagePricingTier::firstOrCreate(
            ['package_id' => $featuredPkg->id, 'validity_days' => 7],
            ['base_price' => 4.99, 'discount_percentage' => 0, 'is_popular' => true]
        );

        $boostPkg = AdPackage::firstOrCreate(
            ['slug' => 'boost-ad'],
            [
                'type' => 'boost', 
                'name' => 'Boost Ad',
                'description' => 'Jump to top of list', 
                'is_active' => true, 
                'sort_order' => 2, 
                'features' => json_encode(['top_spot' => true]),
                'algorithm_params' => json_encode([]),
            ]
        );
        PackagePricingTier::firstOrCreate(
            ['package_id' => $boostPkg->id, 'validity_days' => 3],
            ['base_price' => 2.99, 'discount_percentage' => 0, 'is_popular' => false]
        );

        // 4. Create Ads
        $category = Category::firstOrCreate(
            ['slug' => 'electronics'],
            ['name' => 'Electronics', 'icon' => 'smartphone']
        );

        $ad1 = Ad::create([
            'user_id' => $user->id,
            'title' => 'iPhone 15 Pro Max - Like New',
            'description' => 'Barely used, battery 100%. Comes with box.',
            'price' => 999,
            'currency' => 'USD',
            'category_id' => $category->id,
            'status' => 'Active',
            'city' => 'New York',
            'latitude' => 40.7128,
            'longitude' => -74.0060,
            'is_featured' => true,
        ]);

        $ad2 = Ad::create([
            'user_id' => $user->id,
            'title' => 'Sony PlayStation 5',
            'description' => 'Disc edition, 2 controllers.',
            'price' => 450,
            'currency' => 'USD',
            'category_id' => $category->id,
            'status' => 'Active',
            'city' => 'New York',
            'latitude' => 40.7128,
            'longitude' => -74.0060,
            'is_boosted' => true,
        ]);

         Ad::create([
            'user_id' => $user->id,
            'title' => 'Old Bicycle',
            'description' => 'Needs repair.',
            'price' => 50,
            'currency' => 'USD',
            'category_id' => $category->id,
            'status' => 'Inactive',
            'city' => 'New York',
            'latitude' => 40.7128,
            'longitude' => -74.0060,
        ]);

        // 5. Create Buyer User & Chat
        $buyer = User::updateOrCreate(
             ['email' => 'buyer@clxpro.com'],
             ['name' => 'Buyer Joe', 'password' => Hash::make('password')]
        );

        // Insert Chat Message
        DB::table('chat_messages')->insert([
            'sender_id' => $buyer->id,
            'receiver_id' => $user->id,
            'ad_id' => $ad1->id,
            'message' => 'Is this still available?',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        
        $this->command->info('Demo Data Seeded!');
    }
}
